// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_SESSION_H
#define TAPIOCA_SESSION_H

#include <gtkmm.h>

#include <sigc++/sigc++.h>
#include <libsoupmm/session.h>
#include <string>
#include <list>
#include <time.h>

#include "profile.h"
#include "document.h"
#include "gallerylist.h"
#include "item.h"
#include "gallery.h"
#include "changed-gallery.h"
#include "changed-document.h"
#include "session-connector.h"

#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/list.hpp>

namespace Tapioca
{
class Session: public GalleryList, public SessionConnector
{
    public:

        Session(const Session& profile);

	Session();

        virtual ~Session();

        void copy_galleries_from_profile();

        void merge_changes(Session *session);

        SessionChanges get_changes() const;

        // Set Methods
        
        void set_profile(Profile *p) {profile = p;}

        // Get Methods

        Profile* get_profile() const {return profile;}

        bool is_changed();

        // Statics
        static Session* create(Profile *profile);

    private:
        Profile *profile;

        friend class boost::serialization::access;
                             
        template<class Archive>
          void serialize(Archive & ar, const unsigned int version)
            {
              ar & profile;
              ar & static_cast<GalleryList&>(*this);
            }
};
}
#endif // TAPIOCA_SESSION_H

