// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include "session.h"
#include "gallery.h"
#include "ucompose.hpp"

using namespace Tapioca;

Session::Session(const Session& p)
: GalleryList(p), SessionConnector(this)
{
  profile = new Profile(*p.profile);
  add(profile); //copying galleries from profile into session
}

void Session::copy_galleries_from_profile()
{
  remove_all_galleries();
  add(profile);
}

Session::Session()
: GalleryList(), SessionConnector(this), profile(0)
{
}

Session::~Session()
{
  delete profile;
}

Session* Session::create(Profile *p)
{
  Session *session = new Session();
  session->set_profile(p);
  session->add(p);
  return session;
}

void Session::merge_changes(Session *session)
{
  //FIXME
  //maybe the old session has some changes in it
  //that we'd like to bring into this session.
  //what's happened is that we've just done an update from the server
  //and our changes are going to be wiped away unless we do something
  //about it.
}

SessionChanges Session::get_changes() const
{
  SessionChanges changes;
  changes.modified_galleries = get_changed_galleries(profile);
  changes.modified_docs = get_changed_documents(profile);
  changes.removed_galleries = profile->get_removed_galleries(this);
  changes.added_galleries = get_removed_galleries(profile);
  changes.removed_documents = profile->get_removed_documents(this);
  changes.added_documents = get_removed_documents(profile);
  return changes;
}

bool Session::is_changed()
{
  return !is_same(*get_profile());
}

