//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include <gtkmm.h>

#include "quit-dialog.h"
#include "main.h"

QuitDialog* QuitDialog::create()
{
  Glib::RefPtr<Gtk::Builder> xml
    = Gtk::Builder::create_from_file(Main::get_glade_path()
				    + "/quit-dialog.gtk");
  QuitDialog *dialog;
  xml->get_widget_derived("dialog", dialog);
  dialog->on_dialog_loaded();
  return dialog;
}

QuitDialog::QuitDialog(BaseObjectType* baseObject, 
                             const Glib::RefPtr<Gtk::Builder>& xml)
 : Gtk::Dialog(baseObject)
{
  set_icon_from_file(Main::get_data_path() + "/icon.png");
}

void QuitDialog::on_dialog_loaded()
{
}

QuitDialog::~QuitDialog()
{
}
