// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_CHANGED_GALLERY_H
#define TAPIOCA_CHANGED_GALLERY_H

#include <gtkmm.h>
#include <string>

#include "gallery.h"

namespace Tapioca
{
class ChangedGallery
{
    public:

	//! Constructor.
        ChangedGallery(const Tapioca::Gallery orig, const Tapioca::Gallery dest);

	//! Destructor.
        virtual ~ChangedGallery();

        Glib::ustring get_change_description() const;

        Tapioca::Gallery first;
        Tapioca::Gallery second;

        //operators
        bool operator==(const ChangedGallery &other)
          {
            return first == other.first && second == other.second;
          }
    protected:

    private:
};
}

#endif // TAPIOCA_CHANGED_GALLERY_H

