//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include <gtkmm.h>

#include "preferences-dialog.h"
#include "main.h"

PreferencesDialog::PreferencesDialog()
{
    Glib::RefPtr<Gtk::Builder> xml
	= Gtk::Builder::create_from_file(Main::get_glade_path()
				    + "/preferences-dialog.gtk");

    xml->get_widget("dialog", dialog);
    dialog->set_icon_from_file(Main::get_data_path() + "/icon.png");

    xml->get_widget("homepage_entry", homepage_entry);
    homepage_entry->signal_key_release_event().connect(sigc::mem_fun(*this,&PreferencesDialog::on_homepage_changed));
    xml->get_widget("tmp_filechooserbutton", tmp_filechooserbutton);
    tmp_filechooserbutton->signal_current_folder_changed().connect(sigc::mem_fun(*this,&PreferencesDialog::on_tmp_folder_changed));
    xml->get_widget("image_viewer_filechooserbutton", 
                    image_viewer_filechooserbutton);
    image_viewer_filechooserbutton->signal_file_set().connect(sigc::mem_fun(*this,&PreferencesDialog::on_image_viewer_changed));
    
         
    conf_client = Gnome::Conf::Client::get_default_client();
    conf_client->add_dir("/apps/" PACKAGE_NAME "/general");


    tmp_folder = conf_client->get_string("/apps/" PACKAGE_NAME "/general/tmp_folder");
    if (tmp_folder == "")
      {
        tmp_folder = "/tmp";
        conf_client->set("/apps/" PACKAGE_NAME "/general/tmp_folder", tmp_folder);
      }
    tmp_filechooserbutton->set_current_folder(tmp_folder);

    image_viewer_path = conf_client->get_string("/apps/" PACKAGE_NAME "/general/image_viewer_path");
    if (image_viewer_path == "")
      {
        image_viewer_path = Glib::find_program_in_path("eog");
        conf_client->set("/apps/" PACKAGE_NAME "/general/image_viewer_path", 
                         image_viewer_path);
      }
    image_viewer_filechooserbutton->set_filename(image_viewer_path);

    homepage = conf_client->get_string("/apps/" PACKAGE_NAME "/general/homepage");
    if (homepage == "")
      {
        homepage = "http://www.atpic.com";
        conf_client->set("/apps/" PACKAGE_NAME "/general/homepage", homepage);
      }

    homepage_entry->set_text(homepage);

    conf_client->notify_add("/apps/" PACKAGE_NAME "/general/tmp_folder",
                            sigc::mem_fun(*this, &PreferencesDialog::key_changed));
    conf_client->notify_add("/apps/" PACKAGE_NAME "/general/image_viewer_path",
                            sigc::mem_fun(*this, &PreferencesDialog::key_changed));
    conf_client->notify_add("/apps/" PACKAGE_NAME "/general/hompage",
                            sigc::mem_fun(*this, &PreferencesDialog::key_changed));
}

PreferencesDialog::~PreferencesDialog()
{
  delete dialog;
}
void PreferencesDialog::set_parent_window(Gtk::Window &parent)
{
    dialog->set_transient_for(parent);
    //dialog->set_position(Gtk::WIN_POS_CENTER_ON_PARENT);
}

void PreferencesDialog::hide()
{
  dialog->hide();
}

void PreferencesDialog::run()
{
  dialog->run();
}

void
PreferencesDialog::key_changed(guint connection_id, Gnome::Conf::Entry entry)
{
  // Make sure the preference has a valid value
  if (entry.get_value().get_type() == Gnome::Conf::VALUE_STRING) 
    {
      if (entry.get_key() == "/apps/" PACKAGE_NAME "/general/tmp_folder")
        {
          Glib::ustring new_setting = entry.get_value().get_string();
          if (new_setting != tmp_folder) 
            {
              tmp_folder = new_setting;
              tmp_filechooserbutton->set_current_folder(tmp_folder);
            }
        }
      if (entry.get_key() == "/apps/" PACKAGE_NAME "/general/image_viewer_path")
        {
          Glib::ustring new_setting = entry.get_value().get_string();
          if (new_setting != image_viewer_path) 
            {
              image_viewer_path = new_setting;
              image_viewer_filechooserbutton->set_filename(image_viewer_path);
            }
        }
      if (entry.get_key() == "/apps/" PACKAGE_NAME "/general/homepage")
        {
          Glib::ustring new_setting = entry.get_value().get_string();
          if (new_setting != homepage) 
            {
              homepage = new_setting;
              homepage_entry->set_text(homepage);
            }
        }
    }
}
    
bool PreferencesDialog::on_homepage_changed(GdkEventKey *event)
{
  homepage = homepage_entry->get_text();
  conf_client->set("/apps/" PACKAGE_NAME "/general/homepage", homepage);
  return true;
}

void PreferencesDialog::on_tmp_folder_changed()
{
  tmp_folder = tmp_filechooserbutton->get_current_folder();
  conf_client->set("/apps/" PACKAGE_NAME "/general/tmp_folder", tmp_folder);
}

void PreferencesDialog::on_image_viewer_changed()
{
  image_viewer_path = image_viewer_filechooserbutton->get_filename();
  conf_client->set("/apps/" PACKAGE_NAME "/general/image_viewer_path", image_viewer_path);
}
