//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_DOCUMENT_DIALOG_H
#define TAPIOCA_DOCUMENT_DIALOG_H

#include <gtkmm.h>
#include <gconfmm.h>
#include "document.h"
using namespace Tapioca;

class DocumentDialog
{
 public:
    DocumentDialog(Tapioca::Document *g);
    ~DocumentDialog();

    void set_parent_window(Gtk::Window &parent);

    void run();
    void hide();

 protected:

 private:
    Tapioca::Document *document;
    Gtk::Dialog* dialog;
    Gtk::Entry *title_entry;
    Gtk::TextView *description_textview;
    Gtk::Image *thumbnail_image;
    Gtk::SpinButton *lat_spinbutton;
    Gtk::SpinButton *lon_spinbutton;
    Gtk::Label *tags_count_label;
    Gtk::TreeView *treeview;
    Gtk::Button *add_button;
    Gtk::Button *remove_button;
    //for the treeview
    class TagsColumns: public Gtk::TreeModelColumnRecord {
  public:
      TagsColumns()
	{add(name);}
      Gtk::TreeModelColumn<Glib::ustring> name;
    };
    const TagsColumns tags_columns;
    Glib::RefPtr<Gtk::ListStore> tags_list;
    Gtk::CellRendererText name_renderer;
    Gtk::TreeViewColumn name_column;
    void cell_data_tag(Gtk::CellRenderer *renderer, const Gtk::TreeIter &i);

    //callbacks
    void on_title_changed();
    void on_description_changed();
    void on_lat_changed();
    void on_lon_changed();
    void on_tag_selected();
    void on_add_clicked();
    void on_remove_clicked();
    void on_tag_edited(const Glib::ustring &path, const Glib::ustring &new_text);
    void on_cancel_tag_edit();

  //helpers
    void fill_tags();
    void add_tag(std::string tag);
    std::string get_selected_tag();

    static std::string default_tag_name;
};

#endif // TAPIOCA_DOCUMENT_DIALOG_H
