#!/usr/bin/python
import os, sys, socket
import SocketServer

############################
############################
class RequestHandler(SocketServer.StreamRequestHandler):
	#############################
	def handle(self):
		"""Access to server data through self.server._data"""
		if not self.server._callback:
			raise ValueError, "handler: callback not defined"
		self.server._callback(self.rfile, self.wfile, *self.server._cb_args, **self.server._cb_kwargs)

#############################
#############################
class UnixSocketServer(SocketServer.UnixStreamServer):
	#############################
	def __init__(self, filename, reuse=False):
		if reuse and os.path.exists(filename):
			os.unlink(filename)
		SocketServer.UnixStreamServer.__init__(self, filename, RequestHandler)
		self._callback = None
	
	#############################
	def set_handler(self, callback, *cb_args, **cb_kwargs):
		self._callback = callback
		self._cb_args = cb_args
		self._cb_kwargs = cb_kwargs
			
#############################
#############################
def get_unixsocket(filename):
	s = socket.socket(socket.AF_UNIX)
	s.connect(filename)
	return s

#############################
#############################
class UnixSocketClient:
	_bsize = 256
	#############################
	def __init__(self, filename):
		s = socket.socket(socket.AF_UNIX)
		s.connect(filename)
		self.s = s

	#############################
	def fileno(self):
		return self.s.fileno()

	#############################
	def write(self, data):
		return self.s.send(data)
		
	#############################
	def read(self, bsize=None):
		bsize = bsize or self._bsize
		return self.s.recv(bsize)

	#############################
	def close(self):
		return self.s.close()

#############################
#############################

#############################
def echo_cb(rfile, wfile, data=None):
	"""Access to server data through self.server._data"""
	while 1:
		line = rfile.readline()
		if not line: break
		wfile.write("%s: %s" %(data, line))

#############################
def main():
	server = UnixSocketServer("/tmp/.test_unixsocket", True, echo_cb, data="test")
	server.serve_forever()

#####################################
if __name__ == "__main__":
	main()