package ASD::Uncompress;

#     This file is part of asd.
    
#     asd is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#     asd 0.2 Copyright 2004 Antonini Daniele <arpeda@gmail.com>

use strict;
use warnings;
use File::stat;

require Exporter;
require 5.005;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use ASD::Function ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw( 
				    unzip_man_page ) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw();

our $VERSION = '0.01';

sub unzip_man_page {
    my $path = shift;

    my @man_page;
    my @man_page_file = split( /\./, $path );

    my $extension = pop @man_page_file;

    if ( $extension =~ /gz/ ) {
	@man_page = `zcat $path`;
    }
    elsif ( $extension =~ /bz2/ ) {
	@man_page = `bzcat $path`;
    }
    elsif ( $extension =~ /\d/ ) {
	@man_page = `cat $path`;
    }
    else {
	print "Cannot analyze $path: is not a .bz2 .gz or plain text\n";
    }

    return \@man_page;

}
