package ASD::Function;

#     This file is part of asd.
    
#     asd is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#     asd 0.2 Copyright 2004 Antonini Daniele <arpeda@gmail.com>

use strict;
use warnings;
use File::stat;

require Exporter;
require 5.005;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use ASD::Function ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw( get_man_page_dir
				    get_section
				    get_basename
				    insert_into_hash_title
				    merge 
				    expand_parameter ) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw();

our $VERSION = '0.01';

sub get_basename {
    my $filename = shift;

    my @filename_splitted;
    @filename_splitted = split( /\./, $filename );

    my $extension = pop @filename_splitted;

    if ( $extension =~ /gz|bz2/ ) {
	pop  @filename_splitted;
	return join( '.', @filename_splitted);
    }
    elsif ( $extension =~ /\d\w*/ ) {
	return join( '.', @filename_splitted);
    }

    return "";
}

sub get_section {
    my $path = shift;

    my @man_page;
    my @man_page_file = split( /\./, $path );

    my $extension = pop @man_page_file;

    if ( $extension =~ /gz|bz2/ ) {
	return pop @man_page_file;
    }
    elsif ( $extension =~ /\d/ ) {
	return $extension;
    }
    else {
	print "Cannot analyze $path: is not a .bz2 .gz or plain text\n";
	return "";
    }

    return "";
}

## manage bash espansion
sub expand_parameter {
    my $parameter = shift;
    my $expansion = shift;

    if ( @$parameter ) {

	if ( $parameter->[0] =~ /--file/ && @$parameter > 2) {

	    for my $i ( 0..$#$parameter ) {

		next if ( $parameter->[$i] =~ /--file/ );
		push @$expansion,"--file";
		push @$expansion, $parameter->[$i];
	    }

	    @$parameter = @$expansion;
	}
    }
}

# Remove duplicate value in an array
sub _remove_dup {
    my $ref_array = shift;
    my %tmp_hash = ();

    foreach my $dir ( @$ref_array ) {
	$tmp_hash{$dir} = 0;
    }
    return sort keys %tmp_hash;
}

#execute manpath command and return an array of dir
sub get_man_page_dir {
    my $tmp_dir = `manpath 2>/dev/null`;
    my $tmp_dir2 = `echo \$MANPATH`;

    chop($tmp_dir);
    chop($tmp_dir2);

    $tmp_dir = join( ':', $tmp_dir, $tmp_dir2 );

    $tmp_dir =~ s/:{2,}/:/g;

    my @dir = split( /:/, $tmp_dir );
    my @dir_unique = &_remove_dup( \@dir );

    @dir = ();

    return @dir_unique;
}

#Insert title into hash_title and get docID
sub insert_into_hash_title {
     my $ref_hash_man_page = shift;
     my $string = shift;
     my $ref_index = shift;

     my $value = undef;
     if ( exists $ref_hash_man_page->{$string} ) {

	 $value = $ref_hash_man_page->{$string};
     } 
     else {
 	$value = ++ $$ref_index ;
 	$ref_hash_man_page->{$string} = $value;
     }

     return $value

}

sub merge {

    my $ref_hash_dict = shift;
    my $ref_hash_man_page = shift;
    my $section_man_page = shift;
    my $man_page_id = shift;
    
    foreach my $word( keys %$ref_hash_man_page ) {
	
	$ref_hash_dict->{$word}{"$man_page_id"} = $ref_hash_man_page->{$word};
    }

    #add section
    $ref_hash_dict->{"_{$section_man_page}_"}{"$man_page_id"} = 0;
    
}

1;
__END__

=head1 NAME

ASD::Function - Perl extension for ASD. It is a collection of function

=head1 SYNOPSIS

  use ASD::Function ':all';

=head1 DESCRIPTION

Simple collection if function for ASD.

=head2 EXPORT

None by default.

=head1 AUTHOR

A. U. Thor, E<lt>antonini.daniele@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2005 by A. U. Thor

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.


=cut
