;; Helper function that does the actual completion

;; Copyright (C) 2002, 2003 Walter Landry and the Regents of the University
;; of California

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

(defun arx-do-completion (partial-name name-list predicate flag)
  "Helper function that does the actual completion.  name-list is
generated by another function that sends it here to see what the
completions are."
  (if (not flag)
      (try-completion partial-name (mapcar (lambda (sym) (cons sym 0))
					   name-list) predicate)
    (if (equal t flag)
	(all-completions partial-name
			 (mapcar (lambda (sym) (cons sym 0))
				 name-list) predicate)
      ;; flag==lambda
      (let ((name) (result))
	(dolist (name name-list result)
	  (if (string= partial-name name)
	      (setq result t)))))))
