<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// MAIN INCLUDES ------------------------------------------------------------------
include ("components/core/config/core.config.php");
include ("components/core/inc/functions.inc.php");


// SESSION HANDLER -------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['node']['php_session_name']);
session_start();
session_unset();
session_destroy();

$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];



// SETUP LANGUAGE ------------------------------------------
$lang = array();
$language_path_core = "components/core/language/" . $_SESSION['language_code'] . "/";
include_once($language_path_core . 'common.lang.php');
include_once($language_path_core . 'overview.lang.php');

$template_path_core = "components/core/template/";

require_once('components/core/class/Template.class.php');
$tpl = new Template();
$body = new Template();

$tpl->set('lang', $lang);
$body->set('lang', $lang);
$tpl->set('template_path_core', $template_path_core);
$body->set('template_path_core', $template_path_core);
$body->set('core_config', $core_config);
$tpl->set('core_config', $core_config);
$tpl->set('script_name', 'overview');

// SETUP DATABASE ------------------------------------------------------
require_once('components/core/class/Db.class.php');
$db = new Database($core_config['db']);

if (!empty($_REQUEST['search'])) {

	$query = "
		SELECT COUNT(*) AS total
		FROM " . $db->prefix . "_webspace
		WHERE 
		MATCH(webspace_title, webspace_description, webspace_keywords) 
		AGAINST (" . $db->qstr($_REQUEST['search']) . ") AND
		status_id=3 AND webspace_locked is NULL"
	;
	$result = $db->Execute($query, 1);
	
	if ($result) {
		$total = $result[0]['total'];
		$body->set('total_nr_of_rows', $total);
	}
	
	$query = "
		SELECT MATCH(webspace_title, webspace_description, webspace_keywords) 
		AGAINST (" . $db->qstr($_REQUEST['search']) . ") AS score
		FROM " . $db->prefix . "_webspace
		WHERE 
		MATCH(webspace_title, webspace_description, webspace_keywords) 
		AGAINST (" . $db->qstr($_REQUEST['search']) . ") AND
		status_id=3 AND webspace_locked is NULL  
		ORDER BY score DESC"
	;
	$result = $db->Execute($query);

	if ($result) {
		$max = $result[0]['score'];
	}

	$query = "
		SELECT webspace_id, webspace_unix_name, webspace_description, 
 		webspace_keywords, webspace_title, webspace_create_datetime,
		MATCH(webspace_title, webspace_description, webspace_keywords) 
		AGAINST (" . $db->qstr($_REQUEST['search']) . ") AS score
		FROM " . $db->prefix . "_webspace
		WHERE
		MATCH(webspace_title, webspace_description, webspace_keywords)
		AGAINST (" . $db->qstr($_REQUEST['search']) . ") AND
		status_id=3 AND webspace_locked is NULL 
		ORDER BY score DESC"
	;

	$from = isset($_GET['_frm']) ? (int) $_GET['_frm'] : 0;
	$output_webspaces = $db->Execute($query, $core_config['display']['max_list_rows'], $from);

	if (!empty($output_webspaces)) {
		foreach($output_webspaces as $key => $g):
			$output_webspaces[$key]['percentage'] = round(($g['score'] / $max) * 100);
		
			$webspace_url = 'index.php?ws=' . $g['webspace_id'];
			
			$output_webspaces[$key]['webspace_url'] = $webspace_url;
		endforeach;
		$body->set('search_webspaces', $output_webspaces);
	}
}
else {

	$query = "
		SELECT COUNT(*) AS total
		FROM " . $db->prefix . "_webspace
		WHERE status_id=3 AND webspace_locked is NULL"
	;
	$result = $db->Execute($query);
	
	if (isset($result[0]['total'])) {
		$total = $result[0]['total'];
		$body->set('total_nr_of_rows', $total);
	}

	$query = "
		SELECT w.webspace_id, w.webspace_unix_name, w.webspace_description, 
		w.webspace_keywords, w.webspace_title, w.webspace_create_datetime
		FROM " . $db->prefix . "_webspace w
		WHERE w.status_id=3 AND webspace_locked is NULL 
		ORDER BY w.webspace_create_datetime DESC"
	;

	$from = isset($_GET['_frm']) ? (int) $_GET['_frm'] : 0;
	$output_webspaces = $db->Execute($query, $core_config['display']['max_list_rows'], $from);
	
	if (!empty($output_webspaces)) {
		foreach($output_webspaces as $key => $g):
		
			$webspace_url = 'index.php?ws=' . $g['webspace_id'];
			
			$output_webspaces[$key]['webspace_url'] = $webspace_url;
		endforeach;
		$body->set('webspaces', $output_webspaces);
	}
}


$tpl->set('content', $body->fetch("components/core/template/overview.tpl.php"));
echo $tpl->fetch($template_path_core . 'wrapper.tpl.php');

?>