<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

	<title>AROUNDMe identity server Installer</title>

	<style type="text/css">
	<!--
	<?php include("core/template/css/aroundme.css");?>
	-->
	</style>
</head>

<body id="am_admin">
	<?php
	if (!empty($GLOBALS['am_error_log'])) {
	?>
	<div id="error_container">
		<?php
		foreach($GLOBALS['am_error_log'] as $key => $i):
		?>
			<?php
			if (isset($lang['error'][$i[0]])) {
				echo $lang['error'][$i[0]];
			}
			else {
				echo $i[0];
			}
	
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		<?php
		endforeach;
		?>
	</div>
	<?php }?>
	
	
	<form method="POST">

	<?php
	if (!isset($display)) {
	?>

		<div class="box">
			<h1>AROUNDMe identity server installer</h1>

			<p>
				This installer will install version '<?php echo $core_config['release']['version'];?>' of Barnraisers AROUNDMe identity server.
			</p>

			<?php
			if (empty($GLOBALS['am_error_log'])) {
			?>
			<p>
				<input type="submit" name="start_install" value="start installation" />
			</p>
			<?php }?>
		</div>

	<?php
	}
	elseif (isset($display) && $display == "setup") {
	?>
		<div class="box">
			<h1>Configure database</h1>

			<p>
				<label for="id_database_host">Host</label>
				<input type="text" name="database_host" id="id_database_host" value="<?php if (isset($core_config['db']['host'])) { echo $core_config['db']['host'];}?>" />
				<i>Example: localhost</i>
			</p>

			<p>
				<label for="id_database_user">Username</label>
				<input type="text" name="database_user" id="id_database_user" value="<?php if (isset($core_config['db']['user'])) { echo $core_config['db']['user'];}?>" />
			</p>

			<p>
				<label for="id_database_password">Password</label>
				<input type="password" name="database_password" id="id_database_password" value="<?php if (isset($core_config['db']['password'])) { echo $core_config['db']['password'];}?>" />
			</p>

			<p>
				<label for="id_database_db">Database name</label>
				<input type="text" name="database_db" id="id_database_db" value="<?php if (isset($core_config['db']['db'])) { echo $core_config['db']['db'];} else { echo "aroundme_collaboration";}?>" />
				<i>Example: aroundme_identity_server</i>
			</p>
		</div>

		<div class="box">
			<h1>Set maintainer access</h1>

			<p>
				Set up the master administrator ("the maintainer") username and password.
			</p>

			<p>
				<label for="id_maintainer_username">Maintainer username</label>
				<input type="text" id="id_maintainer_username" name="maintainer_username" value="<?php if (isset($_POST['maintainer_username'])) echo $_POST['maintainer_username']; ?>" />
			</p>
			
			<p>
				<label for="id_maintainer_password1">Maintainer password</label>
				<input type="password" value="" name="maintainer_password1" id="id_maintainer_password1" />
			</p>
			
			<p>
				<label for="id_maintainer_password2">Verify password</label>
				<input type="password" value="" name="maintainer_password2" id="id_maintainer_password2" />
			</p>
		</div>

		<div class="box">
			<h1>Setup registration</h1>

			<p>
				<input type="radio" value="2" name="identity_creation_type" checked="checked" />Anyone can create an OpenID account and automatically start using it.
			</p>

			<p>
				<input type="radio" value="0" name="identity_creation_type" />Only the maintainer can create an OpenID account.
			</p>
		</div>

		<p align="right">
			<input type="submit" name="setup" value="perform installation" />
		</p>
	<?php }?>
	</form>
</body>
</html>




