<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

// MAIN INCLUDES 
include ("core/config/aroundme_core.config.php");
include ("core/inc/functions.inc.php");


// SESSION HANDLER ------------------------------------------------------
// sets up all session and global vars
session_name($core_config['php']['session_name']);
session_start();


// SECURITY CHECK --------------------------------------------------------
if (!isset($_SESSION['am_maintainer']) && $core_config['am']['identity_creation_type'] != 1 && $core_config['am']['identity_creation_type'] != 2) {

	exit;
}


// ERROR HANDLING
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['am_error_log'] = array();


// SETUP DATABASE ------------------------------------------------------
require_once('core/class/Db.class.php');
$db = new Database($core_config['db']);


// SETUP TEMPLATE -------------------------------------------
define("AM_TEMPLATE_PATH", "core/template/");
require_once('core/class/Template.class.php');
$tpl = new Template();


// SETUP LANGUAGE --------------------------------------------
$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
$locale_code = $core_config['language']['localization'][strtoupper($_SESSION['language_code'])];
setlocale(LC_ALL, $locale_code);

$lang = array();

define("AM_LANGUAGE_PATH", "core/language/" . $_SESSION['language_code'] . "/");

include_once(AM_LANGUAGE_PATH . 'common.lang.php');
include_once(AM_LANGUAGE_PATH . 'register.lang.php');


if (isset($_POST['reject_terms'])) {
	$tpl->set('stage', 1);
}
elseif (isset($_POST['accept_terms'])) {
	$tpl->set('stage', 2);
}
elseif(isset($_POST['check_username'])) {
	$username = trim($_POST['username']);

	if (empty($username)) {
		$GLOBALS['am_error_log'][] = array('identity name empty');
	}
	else {
		$username = formatIdentityName($username);
	}

	if (empty($GLOBALS['am_error_log'])) {
		if (testIdentityName($db, $username, $core_config['am']['reserved_identity_names'])) {

			$tpl->set("name_ok", 1);

			$lang['txt_username_available'] = str_replace("SYS_KEYWORD_NAME", $username, $lang['txt_username_available']);
		}
		else {
			$tpl->set("name_in_use", 1);

			$lang['txt_username_taken'] = str_replace("SYS_KEYWORD_NAME", $username, $lang['txt_username_taken']);
		}
	}

	$tpl->set('stage', 2);
}
elseif (isset($_POST['choose_again'])) {
	$tpl->set('stage', 2);
}
elseif (isset($_POST['choose_username'])) {
	$tpl->set('stage', 3);

	$username = trim($_POST['username']);
	$openid = str_replace('REPLACE', $username, $core_config['am']['domain_replace_pattern']);
	$tpl->set('username', $username);
	$tpl->set('openid', $openid);
}
elseif (isset($_POST['register_password'])) {

	if ($_POST['pass1'] != $_POST['pass2']) {
        $GLOBALS['am_error_log'][] = array("Passwords must match.");
    }

    if (strlen($_POST['pass1']) < 2) {
        $GLOBALS['am_error_log'][] = array('Password must be at least 2 characters long.');
    }
    
    if (empty($GLOBALS['am_error_log'])) {
    	$tpl->set('stage', 4);
    }
    else {
    	$tpl->set('stage', 3);
    }
    
    $username = trim($_POST['username']);
	$openid = str_replace('REPLACE', $username, $core_config['am']['domain_replace_pattern']);
	$tpl->set('username', $username);
	$tpl->set('openid', $openid);
}
elseif (isset($_POST['register_challange'])) {

	if (isset($_SESSION['hash']) && $_SESSION['hash'] !== md5(strtoupper($_POST['captcha_text']))) {
		$GLOBALS['am_error_log'][] = array("Security code does not match image. Please try again.");
	}

	if (empty($GLOBALS['am_error_log'])) {
		$username = trim($_POST['username']);
		$password = md5(trim($_POST['pass1']));

		$rec = array();
		$rec['identity_name'] = $username;
		$rec['identity_create_datetime'] = time();
		$rec['language_code'] = $_SESSION['language_code'];
		$rec['status_id'] = $core_config['am']['identity_creation_type'];
		$rec['identity_password'] = $password;

		$table = $db->prefix . "_identity";

		$db->insertDb($rec, $table);

		$identity_id = $db->insertID();

		// insert connection
		$rec = array();
		$rec['identity_id'] = $identity_id;
		$rec['connection_openid'] = str_replace('REPLACE', $username, $core_config['am']['domain_replace_pattern']);
		$rec['connection_openid'] = rtrim($rec['connection_openid'], '/');
		$rec['connection_total'] = 1;
		$rec['connection_create_datetime'] = time();
		$rec['connection_last_datetime'] = time();

		$table = $db->prefix . '_connection';

		$db->insertDb($rec, $table);

		$connection_id = $db->insertID();

		if (!empty($connection_id)) {

			$query = "
				UPDATE " . $db->prefix . "_identity
				SET owner_connection_id=" . $connection_id . "
				WHERE identity_id=" . $identity_id
			;

			$db->Execute($query);

			// Insert nickname as attribute
			$rec = array();
			$rec['connection_id'] = $connection_id;
			$rec['attribute_name'] = "namePerson/friendly";
			$rec['attribute_value'] = $username;

			$table = $db->prefix . '_connection_attribute';

			$db->insertDb($rec, $table);
		}


		$tpl->set('stage', 5);
	}
	else {
		$tpl->set('stage', 4);
	}

	$username = trim($_POST['username']);
	$openid = str_replace('REPLACE', $username, $core_config['am']['domain_replace_pattern']);
	$tpl->set('username', $username);
	$tpl->set('openid', $openid);
}
else {
	$tpl->set('stage', 1);
}


$tpl->set('lang', $lang);
$tpl->set('core_config', $core_config);

echo $tpl->fetch(AM_TEMPLATE_PATH . 'register.tpl.php');


function formatIdentityName($id) {
	$id = strtolower($id);

	if (!preg_match('/^[a-zA-Z0-9.~]+$/', $id)) {
		$GLOBALS['am_error_log'][] = array("Sorry, you can only use a-z, A-Z characters, 0-9 numericals or . (dot) in your name.");
	}

	if (strlen($id) < 2) {
        $GLOBALS['am_error_log'][] = array('Username must be at least 2 characters long.');
    }

	if (strlen($id) > 30) { // link too long
		$GLOBALS['am_error_log'][] = array('name_too_long');
	}
	return $id;
}


function testIdentityName ($db, $name, $excluded) {
	// create excluded array
	$excluded = explode(',',$excluded);

	foreach($excluded as $key => $i):
		$excluded[$key] = trim($i);
	endforeach;

	// Test that name is not in excluded list
	if (in_array($name, $excluded)) {
		$GLOBALS['am_error_log'][] = array('Sorry, this identity name is reserved.');
		return 0;

	}

	// Test the name is not already in use
	$query = "
		SELECT identity_name
		FROM " . $db->prefix . "_identity
		WHERE
		identity_name=" . $db->qstr($name)
	;

	$result = $db->Execute($query);

	if (!empty($result)) {
		return 0;
	}
	else {
		return 1;
	}
}

?>