<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

	<title><?php echo $lang['txt_html_title'];?></title>
	
	<style type="text/css">
	<!--
	@import url(<?php echo AM_TEMPLATE_PATH;?>css/aroundme.css);
	-->
	</style>
	
	<!--[if IE]>
	<style type="text/css">
	@import url(<?php echo AM_TEMPLATE_PATH;?>css/aroundme-IE.css);
	</style>
	<![endif]-->
</head>

<body id="am_admin">
	<?php
	if (isset($_SESSION['am_maintainer'])) {
	?>
	<div id="am_menu_container">
		<ul>
			<li><a href="maintain.php"><?php echo $lang['href_menu_home'];?></a></li>
			<li><a href="maintain.php?v=list">Accounts</a></li>
			<li><a href="maintain.php?v=config"><?php echo $lang['href_menu_configure'];?></a></li>
			<li><a href="maintain.php?disconnect=1">Logoff</a></li>
		</ul>
	</div>
	<?php }?>
	
	<?php
	if (!empty($GLOBALS['am_error_log'])) {
	?>
	<div id="error_container">
		<?php
		foreach($GLOBALS['am_error_log'] as $key => $i):
		?>
			<?php
			if (isset($lang['error'][$i[0]])) {
				echo $lang['error'][$i[0]];
			}
			else {
				echo $i[0];
			}
	
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		<?php
		endforeach;
		?>
	</div>
	<?php }?>
	
	<div id="body_container">
		<form action="maintain.php" method="POST">
		<input type="hidden" name="identity_id" value="<?php if (isset($maintain_identity['identity_id'])) { echo $maintain_identity['identity_id'];}?>" />

		<?php
		if (isset($_SESSION['am_maintainer']) && isset($_REQUEST['v']) && $_REQUEST['v'] == "list") {
		?>

			<?php
			if (isset($maintain_identity)) {
			?>
			<h1>Manage identity</h1>
			
			<p>
				<b><?php echo $lang['txt_label_name'];?></b><br />
				<a href="<?php echo $maintain_identity['identity_url'];?>"><?php echo $maintain_identity['identity_name'];?></a>
			</p>

			<p>
				<b>nickname</b><br />
				<?php echo $maintain_identity['attributes']['namePerson/friendly'];?>
			</p>

			<?php
			if (isset($maintain_identity['attributes']['contact/email'])) {
			?>
			<p>
				<b><?php echo $lang['txt_label_email'];?></b><br />
				<a href="mailto:<?php echo $maintain_identity['attributes']['contact/email'];?>"><?php echo $maintain_identity['attributes']['contact/email'];?></a>
			</p>
			<?php }?>
			
			<p>
				<b><?php echo $lang['txt_label_created'];?></b><br />
				<?php echo strftime("%d %b %G", $maintain_identity['identity_create_datetime']);?>
			</p>

			<p>
				<b><?php echo $lang['txt_label_language'];?></b><br />
				<?php echo $maintain_identity['language_code'];?>
			</p>

			<p>
				<label for="id_status"><?php echo $lang['txt_label_status'];?></label><br />
				<select name="status_id" id="id_status">
					<?php
					$selected = "";

					if ($maintain_identity['status_id'] == 1) {
						$selected = " selected=\"selected\"";
					}
					?>
					<option value="1"<?php echo $selected ;?>><?php echo $lang['arr_identity_status'][1];?></option>
					<?php
					$selected = "";

					if ($maintain_identity['status_id'] == 2) {
						$selected = " selected=\"selected\"";
					}
					?>
					<option value="2"<?php echo $selected ;?>><?php echo $lang['arr_identity_status'][2];?></option>
					<?php
					$selected = "";

					if ($maintain_identity['status_id'] == 3) {
						$selected = " selected=\"selected\"";
					}
					?>
					<option value="3"<?php echo $selected ;?>><?php echo $lang['arr_identity_status'][3];?></option>
				</select>
			</p>

			<p>
				<label for="id_webspace_allocation"><?php echo $lang['txt_label_allocation'];?></label><br />
				<input id="id_webspace_allocation" size="5" name="webspace_allocation" value="<?php echo $maintain_identity['webspace_allocation'];?>" />&nbsp;kb
			</p>

			<p align="right">
				<input type="submit" name="update_identity" value="<?php echo $lang['sub_save'];?>" />
			</p>

			<?php
			}
			elseif (isset($identities)) {
			?>
			<h1><?php echo $lang['hdr_manage_webspace'];?></h1>
			
			<table cellspacing="2" cellpadding="2" border="0" width="100%">
				<tr>
					<th>edit identity</th>
					<th>owner</th>
					<th>created</th>
					<th>status</th>
					<th>language</th>
					<th>webspace</th>
					<th>allocation</th>
					<th>visit</th>
				</tr>
				<?php
				foreach ($identities as $key => $i):
				?>
				<tr>
					<td valign="top">
						<a href="maintain.php?identity_id=<?php echo $i['identity_id'];?>"><?php echo $i['identity_name'];?></a>
					</td>
					<td valign="top">
						<?php
						if (isset($i['attributes']['contact/email'])) {
						?>
							<a href="mailto:<?php echo $i['attributes']['contact/email'];?>"><?php echo $i['attributes']['namePerson/friendly'];?></a>
						<?php
						}
						else {
							echo $i['attributes']['namePerson/friendly'];
						}
						?>
					</td>
					<td valign="top">
						<?php echo strftime("%d %b %G", $i['identity_create_datetime']);?>
					</td>
					<td valign="top">
						<?php
						if (isset($lang['arr_identity_status'][$i['status_id']])) {
							echo $lang['arr_identity_status'][$i['status_id']];
						}?>
					</td>
					<td valign="top">
						<?php echo $i['language_code'];?>
					</td>
					<td valign="top">
						<?php
						if (isset($i['webspace_id'])) {
							echo "yes";
						}
						?>
					</td>
					<td valign="top">
						<?php
						if (isset($i['webspace_allocation'])) {
							echo $i['webspace_allocation'];
						}
						?>
					</td>
					<td valign="top">
						<a href="<?php echo $i['identity_url'];?>"><?php echo $lang['href_visit'];?></a>
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php
			}
			else {
			?>
			<h1>accounts</h1>

			<p>
				no openid accounts
			</p>
			<?php }?>
			
		<?php
		}
		elseif (isset($_SESSION['am_maintainer']) && isset($_REQUEST['v']) && $_REQUEST['v'] == "config") {
		?>

			<table cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr>
					<td valign="top" width="50%">
						<div class="box">
							<div class="box_header">
								<h1><?php echo $lang['hdr_configure_webspace'];?></h1>
							</div>
			
							<div class="box_body">
								<p>
									<label for="id_file_default_allocation"><?php echo $lang['txt_label_allocation'];?></label>
									<input type="text" name="file_default_allocation" id="id_file_default_allocation" value="<?php echo $core_config['file']['default_allocation'];?>" />
								</p>
								
								<p>
									<label for="id_display_max_list_rows"><?php echo $lang['txt_label_list_length'];?></label>
									<input type="text" name="display_max_list_rows" id="id_display_max_list_rows" value="<?php echo $core_config['display']['max_list_rows'];?>" />
								</p>
								
								<p>
									<label for="id_openid"><?php echo $lang['txt_label_create_type'];?></label><br />
									<input type="radio" name="identity_creation_type" value="0" checked="checked" />Only maintainer<br />
									<input type="radio" name="identity_creation_type" value="1"<?php if ($core_config['am']['identity_creation_type'] == 1) { echo " checked=\"checked\"";}?> /><?php echo $lang['txt_label_create_type_approve'];?><br />
									<input type="radio" name="identity_creation_type" value="2"<?php if ($core_config['am']['identity_creation_type'] == 2) { echo " checked=\"checked\"";}?> /><?php echo $lang['txt_label_create_type_auto'];?>
								</p>
	
								<p>
									<label for="id_reserved_identity_names"><?php echo $lang['txt_label_reserved_names'];?></label>
									<input type="text" name="reserved_identity_names" id="id_reserved_identity_names" value="<?php echo $core_config['am']['reserved_identity_names'];?>" />
								</p>
	
								<p>
									<input type="submit" name="save_config" value="<?php echo $lang['sub_save'];?>" />
								</p>
							</div>
						</div>
					</td>
					
					<td valign="top" width="50%">

						<div class="box">
							<div class="box_header">
								<h1><?php echo $lang['hdr_configure_email'];?></h1>
							</div>
			
							<div class="box_body">
								<p>
									<label for="id_email_address"><?php echo $lang['txt_label_email_default'];?></label>
									<input type="text" name="email_address" id="id_email_address" value="<?php echo $core_config['mail']['email_address'];?>" />
								</p>
							
								<p>
									<label for="id_email_host"><?php echo $lang['txt_label_email_host'];?></label>
									<input type="text" name="email_host" id="id_email_host" value="<?php echo $core_config['mail']['host']?>" /><br />
									<i><?php echo $lang['txt_email_host_help'];?></i>
								</p>
								
								<p>
									<?php echo $lang['txt_email_smtp_user_pass'];?>
								</p>
							
								<p>
									<label for="id_email_smtp_user"><?php echo $lang['txt_label_email_username'];?></label>
									<input type="text" name="smtp_user" id="id_email_smtp_user" value="<?php if (isset($core_config['mail']['smtp']['username'])) { echo $core_config['mail']['smtp']['username'];}?>" />
								</p>
							
								<p>
									<label for="id_email_smtp_password"><?php echo $lang['txt_label_email_password'];?></label>
									<input type="text" name="smtp_password" id="id_email_smtp_password" value="<?php if (isset($core_config['mail']['smtp']['password'])) { echo $core_config['mail']['smtp']['password'];}?>" />
								</p>
	
								<p>
									<input type="submit" name="save_email" value="<?php echo $lang['sub_save'];?>" />
								</p>
							</div>
						</div>
						

						<div class="box">
							<div class="box_header">
								<h1><?php echo $lang['hdr_configure_domain'];?></h1>
							</div>
			
							<div class="box_body">
								<p>
									<?php echo $lang['txt_configure_domain_intro'];?>
								</p>

								</p>

								<p>
									<label for="id_domain_preg_pattern"><?php echo $lang['txt_label_pattern_parse'];?></label>
									<input type="text" name="domain_preg_pattern" id="domain_preg_pattern" value="<?php echo $core_config['am']['domain_preg_pattern'];?>" />
								</p>
				
								<p>
									<label for="id_domain_replace_pattern"><?php echo $lang['txt_label_pattern_render'];?></label>
									<input type="text" name="domain_replace_pattern" id="id_domain_replace_pattern" value="<?php echo $core_config['am']['domain_replace_pattern'];?>" />
								</p>
	
								<p>
									<input type="submit" name="save_patterns" value="<?php echo $lang['sub_save'];?>" />
								</p>
							</div>
						</div>
					</td>
				</tr>
			</table>
		<?php
		}
		elseif (isset($_SESSION['am_maintainer'])) {
		?>

			<table cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr>
					<td valign="top" width="50%">
						<?php
						if (isset($_REQUEST['install']) && $_REQUEST['install'] == "complete") {
						?>
						<div class="box">
							<div class="box_header">
								<h1>Installation completed</h1>
							</div>
			
							<div class="box_body">
								<p>
									You have now completed your installation of AROUNDMe identity server.
								</p>
							</div>
						</div>
						<?php }?>
						
						<div class="box">
							<div class="box_header">
								<h1>Statistics</h1>
							</div>
			
							<div class="box_body">
								<?php
								if (isset($statistics)) {
								?>
								<table cellspacing="4" cellpadding="2" border="0">
								<?php
								foreach ($statistics as $key => $i):
								?>
								<tr>
									<td>
										<?php echo $lang['arr_identity_status'][$i[0]];?>
									</td>
									<td align="right">
										<?php echo $i[1];?>
									</td>
								</tr>
								<?php
								endforeach;
								?>
								</table>
								<?php }?>
							</div>
						</div>
					</td>

					<td valign="top" width="50%">
						<div class="box">
							<div class="box_header">
								<h1>Create account</h1>
							</div>
			
							<div class="box_body">
								<p>
									create an account for a person.
									<ul>
										<li><a href="register.php">create account</a></li>
									</ul>
								</p>
							</div>
						</div>
					</td>
				</tr>
			</table>
		<?php
		}
		else {
		?>
			<div class="box" style="text-align:left;margin-left:auto;margin-right:auto; width:380px;">
				<h1><?php echo $lang['hdr_maintainer_access'];?></h1>
			
				<p>
					<label for="id_username">username</label><input type="text" name="username" id="id_username"/><br />
					<label for="id_password">password</label><input type="password" name="password" id="id_password"/><br />
					<input name="connect" type="submit" value="login" />
				</p>
			</div>
		<?php }?>
	</form>
	</body>
</html>
