<script type="text/javascript">
	//<![CDATA[
	function clean() {
		if (document.getElementById('id_guestbook_body').value == 'Type something here:)') {
			document.getElementById('id_guestbook_body').value = '';
			return false;
		}
	}

	function imposeMaxLength(Object, MaxLen) {
		return (Object.value.length <= MaxLen);
	}
	//]]>
</script>

<div class="barnraiser_guestbook_list">
    <div class="block">
        <div class="block_body">
            <?php
            if (isset($barnraiser_guestbook_entries)){
            ?>
            <table cellspacing="0" cellpadding="2" border="0">
                <?php
                foreach ($barnraiser_guestbook_entries as $key => $i):
                ?>
               <tr>
                    <td valign="top" width="35" rowspan="2">
						<?php
						if (!empty($i['connection_avatar'])) {
						?>
							<a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>" class="avatar"><img src="<?php echo $i['connection_openid'] . "/" . $i['connection_avatar'];?>" width="40" height="40" alt="" border="" /></a>
						<?php
						}
						else {
						?>
							<a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>" class="no_avatar"><div title="<?php echo $i['connection_nickname']; ?>"></div></a>
						<?php }?>
					</td>
					<td>
                        <a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>" class="connection"><?php echo $i['connection_nickname']?></a>
                    </td>
                    <td align="right">
                        <span class="datetime"><?php echo strftime("%d %b %G %H:%M", $i['guestbook_create_datetime']);?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span class="body"><?php echo $i['guestbook_body']?></span>
                    </td>
                </tr>
                <?php
                endforeach;
                ?>
            </table>
            <?php
            }
            else {
            ?>
            <p>
                <?php echo $lang['txt_no_guestbooks'];?>
            </p>
            <?php }?>
  
           <div class="add">
                <?php
                if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $plugin_permissions['barnraiser_guestbook']['add_entry']) {
                ?>
                <form action="plugins/barnraiser_guestbook/add_guestbook.php?wp=<?php echo AM_WEBPAGE_NAME;?>" method="post">
                <textarea rows="4" cols="34" name="guestbook_body" id="id_guestbook_body" onkeypress="return imposeMaxLength(this, 200);" onFocus="clean();">Type something here:)</textarea><br />
                <input type="submit" name="insert_guestbook" value="<?php echo $lang['href_add'];?>" onClick="clean();" />
                </form>
                <?php }?>
            </div>
        </div>

		<div class="block_footer">
			<?php
			if (!isset($_SESSION['connection_permission']) || !($_SESSION['connection_permission'] & $plugin_permissions['barnraiser_forum']['add_reply'])) {
			?>
			<span class="disabled_link" onclick="javascript:showInterfaceSystemMessage(event, 'no_guestbook_add_title', 'no_guestbook_add_message');">add comment</span>&nbsp;
			<span style="display:none;">
				<span id="no_guestbook_add_title">Permissions problem:</span>
				<span id="no_guestbook_add_message">
					You do not have permissions to add a guestbook entry.
					<?php
					if (isset($_SESSION['connection_id'])) {
					?>
					If you are connected then look in your <a href="index.php?t=network&amp;connection_id=<?php echo $_SESSION['connection_id'];?>">account page</a> where you will find more information about your membership.
					<?php
					}
					else {
					?>
					Try <a href="index.php?t=login" class="login">connecting</a> first.
					<?php }?>
				</span>
			</span>
			<?php }?>
			
        	<?php
			if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $plugin_permissions['barnraiser_guestbook']['maintain']) {
        	?>
            	<a href="index.php?p=barnraiser_guestbook&amp;t=maintain&amp;wp=<?php echo AM_WEBPAGE_NAME;?>" class="maintain"><?php echo $lang['href_maintain'];?></a>
        	<?php }?>
        </div>
    </div>
</div>