<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<form action="create_webspace.php" method="POST">
<input type="hidden" name="webspace_id" value="<?php if (isset($webspace_id)) { echo $webspace_id;}?>" />

<div id="am_core_area">
	<table cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td width="240" valign="top">
				<h1><?php echo $lang['hdr_webspace_intro'];?></h1>
				<p>
					<?php echo $lang['txt_admin_intro'];?><br />
				</p>
			</td>
			<td width="30" style="border-right: 1px solid #333">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="30" height="1" border="0" alt="" /><br />
			</td>
			<td width="40">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="40" height="1" border="0" alt="" /><br />
			</td>
			<td valign="top">
				
				<?php if (empty($_SESSION['connection_id'])) { ?>
				<div class="box">
					<h1><?php echo $lang['hdr_login'];?></h1>
					<p>
						<?php echo $lang['txt_login'];?><br />
					</p>

					<p>
						<label for="openid_login"><?php echo $lang['txt_label_openid'];?></label><br />
						<input type="text" id="openid_login" name="openid_login" value="" />
						<input name="commit" type="submit" value="<?php echo $lang['sub_login'];?>" class="input_submit" />
					</p>
				</div>

				<?php } ?>

				<?php
				if (isset($_SESSION['connection_id']) && !isset($webspace_id)) {
				?>
				<div class="box">
					<h1><?php echo $lang['hdr_unix_name'];?></h1>
					<p>
						<?php echo $lang['txt_unix_name'];?><br />
					</p>

					<p>
						<input type="text" id="unix_name" name="unix_name" value="<?php if (isset($_POST['unix_name'])) echo $_POST['unix_name']; ?>" />
						<input name="test_unix_name" type="submit" value="<?php echo $lang['sub_test_unix_name'];?>" class="input_submit" />
					</p>
					
					<?php if (isset($select_unix_name)) {
					$url = formatSubDomainUrl($_POST['unix_name']);
					$lang['txt_webspace_free_url'] = str_replace('SYS_KEYWORD_URL', $url, $lang['txt_webspace_free_url']);
					?>
					
					<p>
						<?php echo $lang['txt_webspace_free_url'];?><br />
					</p>

					<p>
						<input name="select_unix_name" type="submit" value="<?php echo $lang['sub_select_unix_name'];?>" class="input_submit" />
					</p>
					<?php } ?>
				</div>
				<?php } ?>
				
			
				<?php if (isset($_SESSION['connection_id']) && isset($webspace_id)) { ?>
				<div class="box">
					<h1><?php echo $lang['hdr_setup_webspace'];?></h1>

					<?php
					$url = formatSubDomainUrl($_POST['unix_name']);
					$lang['txt_webspace_url'] = str_replace('SYS_KEYWORD_URL', $url, $lang['txt_webspace_url']);
					?>
	
					<p>
						<?php echo $lang['txt_webspace_url'];?><br />
					</p>
						
					<p>
						<label for="id_webspace_title"><?php echo $lang['txt_webspace_title'];?></label><br />
						<input type="text" name="webspace_title" id="id_webspace_title" maxlength="150" value="<?php if (isset($_POST['webspace_title'])) { echo $_POST['webspace_title'];}?>" style="width:390px;" />
						<input type="hidden" name="unix_name" value="<?php echo $_POST['unix_name']; ?>" />
					</p>
				
					<?php
					if (count($core_config['language']['pack']) > 1) {
					?>
					
					<p>
						<label for="id_language_id"><?php echo $lang['txt_language'];?></label><br />
						<select name="language_code" id="id_language_code" style="margin-top:6px;">
							<?php
							foreach($core_config['language']['pack'] as $key => $i):
								$selected = "";
								if (isset($_POST['language_code']) && $_POST['language_code'] == $i) {
									$selected = "selected=\"selected\"";
								}
							?>
							<option value="<?php echo $i;?>" <?php echo $selected; ?>><?php echo ucfirst(strtolower($lang['arr_language'][$i]));?></option>
							<?php
							endforeach;
							?>
						</select>
					</p>
					<?php }?>
				
					<p>
						<label for="id_webspace_description"><?php echo $lang['txt_webspace_description'];?></label><br />
						<?php echo $lang['txt_input_description'];?><br />
						<textarea name="webspace_description" id="id_webspace_description" cols="50" rows="3" style="width:390px;" onKeyPress="javascript:inputMaxLength(this, 200, 'description_input_indicator');"><?php if (isset($_POST['webspace_description'])) { echo $_POST['webspace_description'];}?></textarea>
						<span id="description_input_indicator" class="input_indicator"></span>
					</p>
					
					<p>
						<label for="id_webspace_lock"><?php echo $lang['txt_lock_webspace'];?></label><br />
						<?php
						$selected = " checked=\"checked\"";
						if (empty($_POST['webspace_locked']) && isset($_POST['commit_webspace'])) {
							$selected = "";
						}
						?>
						
						<?php echo $lang['txt_lock_intro'];?>&nbsp;<input type="checkbox" id="id_webspace_lock" name="webspace_locked" style="margin:2px;"<?php echo $selected;?> />
					</p>
				</div>

				<div class="box">
					<h1><?php echo $lang['hdr_layout'];?></h1>
					
					<?php
					if (isset($layouts)) {
					?>
					<p>
						<b><?php echo $lang['txt_webspace_layout'];?></b>
					</p>

					<table cellspacing="0" cellpadding="6" border="0">
						<?php foreach($layouts as $key => $t): ?>
						<tr>
							<td valign="top">
								<label for="id_layout_<?php echo $t['name']; ?>"><img src="<?php echo $template_path_core; ?>layouts/<?php echo $t['name']; ?>/thumb.png" style="border: 1px solid black; margin-right: 5px; margin-bottom: 5px; cursor: pointer;" /></label><br />
							</td>
							<td valign="top">
								<input type="radio" id="id_layout_<?php echo $t['name']; ?>" name="layout" value="<?php echo $t['name']; ?>" <?php if($key==0) { echo "checked=\"checked\"";}?> /><br />
							</td>
							<td valign="top">
								<b><?php echo $t['title']; ?></b><br />
								<?php echo $t['description']; ?><br />
							</td>
						</tr>
						<?php
						endforeach; ?>
					</table>
					<?php } ?>
				</div>
				

				<?php
				if ($core_config['am']['webspace_creation_type'] === 1) { // pending
				?>
				<div class="box">
					<h1><?php echo $lang['hdr_pending_application'];?></h1>

					<p>
						<?php echo $lang['txt_pending_application'];?><br />
					</p>

					<p>
						<?php
						if (!empty($_SESSION['openid_email'])) {
						$lang['txt_pending_email'] = str_replace('SYS_KEYWORD_EMAIL', $_SESSION['openid_email'], $lang['txt_pending_email']);
						?>
						<?php echo $lang['txt_pending_email'];?><br />
						<?php
						}
						else {
						?>
						<?php echo $lang['txt_pending_no_email'];?><br />
						<?php }?>
						<?php echo $lang['txt_webspace_maintainer_log'];?><br />
					</p>

					<p>
						<label for="id_status"><?php echo $lang['txt_label_webspace_maintainer_log'];?></label><br />
						<textarea id="id_status" name="webspace_maintainer_log" cols="50" rows="6" style="width:390px;"><?php if (isset($_POST['webspace_maintainer_log'])) { echo $_POST['webspace_maintainer_log'];}?></textarea>
					</p>
				</div>
				<?php }?>
					

				<div class="box">
					<h1><?php echo $lang['hdr_finished'];?></h1>
					<p>
						<?php echo $lang['txt_webspace_finished'];?><br />
					</p>
					
					<p align="right">
						<?php echo $lang['txt_agreement_approval'];?>
						&nbsp;
						<input type="checkbox" name="agreement_approved" value="1" style="margin:2px;" />
						&nbsp;
						<input type="submit" name="commit_webspace" value="<?php echo $lang['sub_finish_create'];?>" class="input_submit" /><br />
					</p>
				</div>
				<?php } ?>
			</td>
		</tr>
	</table>
</div>
</form>