<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


if (isset($_POST['plugin_name']) && isset($_POST['plugin_item_id'])) {

	include_once ("../config/core.config.php");
	
	// SETUP DATABASE ------------------------------------------------------
	require_once('../class/Db.class.php');
	$db = new Database($core_config['db']);
	
	// START SESSION -----------------------------------------------------------
	session_name($core_config['node']['php_session_name']);
	session_start();
	
	if (isset($_POST['insert_tags'])) {
		// delete my tags
		$query = "
			DELETE FROM " . $db->prefix . "_tag
			WHERE 
			webspace_id=" . $_SESSION['webspace_id'] . " AND
			plugin_name=" . $db->qstr($_POST['plugin_name']) . " AND
			plugin_item_id=" . $_POST['plugin_item_id']. " AND
			connection_id=" . $_SESSION['connection_id']
		;

		$result = $db->Execute($query);
		
		$rec = array();
 		$rec['webspace_id'] = $_SESSION['webspace_id'];
		$rec['webpage_id'] = $_POST['webpage_id'];
		$rec['plugin_name'] = $_POST['plugin_name'];
		$rec['plugin_item_id'] = $_POST['plugin_item_id'];
		$rec['connection_id'] = $_SESSION['connection_id'];

		$table = $db->prefix . "_tag";

		if (!empty($_POST['insert_tags'])) {
			// split multiple tags
			$ins_arr = explode(',', $_POST['insert_tags']);
			
			$ins_arr = array_unique($ins_arr); //remove duplicates
			
			$rownums = count($ins_arr);
	
			for ($i=0; $i < $rownums; $i++) {
				
				$tag = trim($ins_arr[$i]);
				
				if (!empty($tag)) {
			
					$rec['tag_name'] = $tag;
					
					$db->insertDb($rec, $table);
				}
			}
		}
	}
	
	// select tags
	$query = "
		SELECT DISTINCT tag_name, connection_id 
		FROM " . $db->prefix . "_tag 
		WHERE 
		webspace_id=" . $_POST['ws'] . " AND
		plugin_name=" . $db->qstr($_POST['plugin_name']) . " AND
		plugin_item_id=" . $_POST['plugin_item_id'] . "
		ORDER BY tag_name"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {

		header("Content-type: application/xml");
		echo '<?xml version="1.0"?>';
		echo '<tags>';

		foreach ($result as $key => $i):
			echo "<tag>" . $i['tag_name'] . "</tag>";

			if ($i['connection_id'] == $_SESSION['connection_id']) {
				echo "<mytag>" . $i['tag_name'] . "</mytag>";
			}
		endforeach;
		
		echo "</tags>";
	}
}
?>