<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<?php
if(isset($item_id)) {
?>
	<script type="text/javascript" language="javascript">
	//<![CDATA[
	<?php if (!empty($_SESSION['connection_id'])) { ?>
		var connection_id = <?php echo $_SESSION['connection_id']; ?>
	<?php } ?>
	
	function addQuote(nic,id) {
		if (quotetext) {
			quote = "\n<a href=\"#comment_id" + id + "\" class=\"quote\" onclick=\"hlComment(" + id + ");\">" + nic + ": " + quotetext + "</a>\n";
	
			comment = document.getElementById('comment_body').value;
			comment += "\n"+quote;
			
			document.getElementById('comment_body').value = comment;
		
			location.hash='#add_comment_form';
		}
		else {
			alert("<?php echo $lang['txt_quote_highlight'];?>");
		}
	}
	
	
	var quotetext = "";
	function getActiveText() {
		quotetext = (document.all) ? document.selection.createRange().text : document.getSelection();
	}
	
	function hlComment(id) {
		document.getElementById('comment_id'+id).className = "quote_source";
	}
	
	function recommendComment(id) {
		var str = "comment_id=" + id + "&connection_id=" + connection_id;
		
		makeRequest('components/comment/relay/recommend_comment.php', str, recommend_comment);
	}
	
	function recommend_comment() {
		
		if (http_request.readyState == 4) {
			if (http_request.status == 200) {
				var result = http_request.responseText.split("|");
				document.getElementById('recommendation_' + result[0]).innerHTML = result[1];
				document.getElementById('comment_' + result[0] + '_recommend').innerHTML = "<?php echo $lang['txt_recommended'];?>";
			}
		}
	}
	//]]>
	</script>
	
	
	<div class="plugin_comment_list">
		<?php
		if (!empty($comments)){
			$url_str = $_SERVER['QUERY_STRING'];
			$url_str = str_replace('&recommended=1', '', $url_str);
			
			$url = "index.php?" . $url_str;
		?>
		
		<div id="list_comments">
			<p align="right">
			<?php if (isset($_REQUEST['recommended'])) { ?>
				<b><a href="<?php echo $url;?>#list_comments"><?php echo $lang['txt_most_recent'];?></a>&nbsp;&#124;&nbsp;<?php echo $lang['txt_contributor_recommended'];?></b>
			<?php } else { ?>
				<b><?php echo $lang['txt_most_recent'];?>&nbsp;&#124;&nbsp;<a href="<?php echo $url;?>&amp;recommended=1#list_comments"><?php echo $lang['txt_contributor_recommended'];?></a></b>
			<?php } ?>
			</p>
		</div>
		<?php
		foreach ($comments as $key => $c):
		?>
		<a name="comment_id<?php echo $c['comment_id'];?>"></a>
	
		<div id="comment_id<?php echo $c['comment_id'];?>">
			<div class="comment">
				<div class="comment_header">
					<span style="float:right;">
							<?php
							if (isset($c['connection_id']) && isset($_SESSION['connection_id']) && $c['connection_id'] == $_SESSION['connection_id']) {
							?>
								<?php echo $lang['txt_recommend'];?>
							<?php
							}
							elseif (!empty($c['recommendation_connection_id'])) {
							?>
								<?php echo $lang['txt_recommended'];?>
							<?php
							}
							else {
							?>
								<?php if (isset($_SESSION['connection_id'])) { ?>
									<span id="comment_<?php echo $c['comment_id']; ?>_recommend"><a href="#comment_id<?php echo $c['comment_id']; ?>" onclick="recommendComment('<?php echo $c['comment_id']; ?>');"><?php echo $lang['txt_recommend'];?></a></span>
								<?php
								}
								else {
								?>
									<?php echo $lang['txt_connect_to_recommend'];?>
								<?php } ?>


							<?php } ?>

						(<span id="recommendation_<?php echo $c['comment_id']; ?>"><?php echo $c['total_recommendations']; ?></span>)

						&nbsp;&#124;&nbsp;

						<a href="#add_comment_form" onmouseover="javascript:getActiveText();" onclick="javascript:addQuote('<?php echo $c['connection_nickname']?>', <?php echo $c['comment_id'];?>);">
						<?php echo $lang['href_quote'];?>
						</a>
					</span>
		
					<?php echo am_strftime($c['comment_create_datetime'],1);?>
					&nbsp;
					<a href="<?php echo $c['connection_openid'];?>"><?php echo $c['connection_nickname']?></a>
					<br />
				</div>
			
				<div class="comment_body">
					<?php echo $c['comment_body'];?>
				</div>

				<div class="comment_footer">
					<hr />
				</div>
			</div>
		</div>
		<?php
		endforeach;
		}
		else {
		?>
		<p>
			<?php echo $lang['txt_no_comments'];?><br />
		</p>
		<?php }?>
	</div>
	
	<?php
		$url = 'index.php?' . http_build_query($_GET);
	?>
	<?php echo paging($total_nr_of_rows, $core_config['display']['max_list_rows'], $url, 'c'); ?> 
	
	<div class="plugin_comment_add">
		<?php
		if (isset($add_comment_locked)) {
		?>
		<p>
			<b><?php echo $lang['txt_locked_no_add'];?></b>
		</p>
		<?php
		}
		elseif (isset($_SESSION['connection_id']) && !empty($_SESSION['webspace_id'])) {
		?>
		<form action="components/comment/relay/add_comment.php" method="post">
		<input type="hidden" name="plugin_name" value="<?php echo $plugin_name;?>" />
		<input type="hidden" name="plugin_item_id" value="<?php echo $item_id;?>" />
		<input type="hidden" name="webpage_id" value="<?php echo $webspace['webpage_id'];?>" />
		
		<a name="add_comment_form"></a>
		<textarea name="comment_body" id="comment_body" cols="80" rows="5"></textarea>
		
		<input type="submit" name="insert_comment" class="input_submit" value="<?php echo $lang['sub_add_comment'];?>" /><br />
		
		</form>
		
		<?php
		}
		else {
		?>
		<p>
			<b><?php echo $lang['txt_connect_to_add'];?></b>
		</p>
		<?php }?>
	</div>
<?php }?>