<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


include "config/aroundme_core.config.php";
include "inc/aroundme_core.functions.php";



// START SESSION --------------------------------------------------------------
session_name($core_config['node']['php_session_name']);
session_start();


if (isset($_REQUEST['help'])) {
	$amn = $_REQUEST['help'];
	$amn_arr = explode("_", $amn, 2);
	$component_id = $amn_arr[0];
	$script_name = $amn_arr[1];
		
}
else {
	$component_id = "core";
	$script_name = "index";
}

$component_path = "../" .$component_id. "/";
$language_path = $component_path . "language/" . $_SESSION['language_id'] . "/" . $_SESSION['template_title'] . "/";
 $helpfile = $language_path . "help/" . $script_name . ".help.lang.php";

$helptxt = readTxtFile($helpfile);


// we format the space
if (!empty($helptxt)) {
	$helptxt = stripslashes($helptxt);
	
	
	//apply any table of contents
	$pattern = "/<toc>(.*?)<\/toc>/";
	
	if (preg_match($pattern, $helptxt, $matches)) {
		$toc = "<div id=\"toc\">" . $matches[0] . "<br />";
		$toc .= "<ul>";
		
		// find h tags and order
		$h_pattern = "/<h(.*?)>(.*?)<\/h/";
		
		if (preg_match_all($h_pattern, $helptxt, $matches)) {
			if (!empty($matches[2])) {
				foreach ($matches[2] as $key => $i):
				
				
				$nbsp = "";
				
 				for($j = 1; $j < $matches[1][$key]; $j++) {
 					$nbsp .= "&nbsp;&nbsp;";
 				}
				
					$toc .= "<li>" . $nbsp . "<a href=\"#atoc" . $key . "\">" . $i . "</a></li>";
					
					// get the H and apply anchor
					$a_pattern = "/<h" . $matches[1][$key] . ">" . $i . "<\/h" . $matches[1][$key] . ">/";
			
					$replacement = "<a name=\"atoc" . $key ."\"></a>\n<h" . $matches[1][$key] . ">" . $i . "</h" . $matches[1][$key] . ">\n";
					
					$helptxt = preg_replace($a_pattern, $replacement, $helptxt);
				endforeach;
			}
			
		}
		
		$toc .= "</ul>";
		$toc .= "</div>";
		
		$helptxt = preg_replace($pattern, $toc, $helptxt);
	}
	
	// SETUP TEMPLATE
	$template_path_core = "template/" . $_SESSION['template_title'] . "/";

	require_once('class/Template.class.php');
	$tpl = & new Template($template_path_core); // outer template
	$tpl->set('template_path_core', $template_path_core);

	// apply any vars to the help texts
	$helptxt = str_replace('SYS_KEYWORD_TEMPLATE_PATH', $template_path_core, $helptxt);
	$tpl->set('helptxt', $helptxt);
	
	// GET LANGUAGES
	$lang = array();
	$language_path = "language/" . $_SESSION['language_id'] . "/" . $_SESSION['template_title'] . "/";
	
	require_once($language_path . 'help.lang.php');

	
	
	$tpl->set('lang', $lang); // language
}

$outer_template_file = "help_content.tpl.php";

echo $tpl->fetch($outer_template_file);


?>