<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


class Announce {

	// the constructor
	// Sebastian Oblom, 5th October 2006
	//
	function Announce($db, $user_id) {
		$this->db = $db;
		$this->user_id = $user_id;	
	}//EO Announce


	// insertAnnouncement
	// inserts a record in the database
	// Sebastian Oblom, 5th October 2006
	//
	function insertAnnouncement($data) {
		$rec = array();
		$rec['announce_title']           = $data['announce_title'];
		$rec['announce_body']            = $data['announce_body'];
		$rec['user_id']                  = $this->user_id;
		$rec['language_id']              = $_SESSION['language_id'];
		$rec['announce_create_datetime'] = time();

		if (!empty($data['email_membership_types'])) {
			// we will need to send emails out for this announcement
			$rec['batch_request'] = 1;
			$rec['start_user_id'] = 0;
		}
		
		$table = $this->db->prefix . "_announce";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);

		if (!empty($result)) {
			$announce_id = $this->db->Insert_ID();
		}

		// we insert any membership types
		if (!empty($data['email_membership_types']) && !empty($announce_id)) {

			$table = $this->db->prefix . "_announce_membership_type";

			foreach($data['email_membership_types'] as $key => $i):

				$rec = array();
				$rec['announce_id'] = $announce_id;
				$rec['membership_type_id'] = $i;

				$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
			endforeach;
		}
	}//EO insertAnnouncement
	
	
	
	// selAnnouncement
	// selects an announcement from the database
	// Sebastian Oblom, 5th October 2006
	//
	function selAnnouncement($announce_id = null, $latest = true) {
		$query = "
			SELECT a.announce_id, a.announce_title, a.announce_body, 
			a.user_id, a.language_id, a.announce_create_datetime, 
			i.identity_nic, i.identity_id 
			FROM " . $this->db->prefix . "_announce a, " . $this->db->prefix . "_user_identity i
			WHERE a.user_id=i.user_id AND i.identity_type=2 AND " 
		;
		
		if (isset($announce_id)) {
			$query .= "a.announce_id=" . $announce_id . " AND ";
		}		
		
		$query .= "1=1";
		
		if ($latest == true) {
			$query .= " ORDER BY a.announce_create_datetime DESC";
		}
		
		$result = $this->db->SelectLimit($query, 1);
		$temp = array();
		
		if (isset($result->fields)) {			
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "function=selAnnouncement class=Announce.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		return $temp;
	}//EO selAnnouncement
	
	
	// selAnnouncements
	// selects announce-ids from the database
	// Sebastian Oblom, 5th October 2006
	//
	function selAnnouncements($nr = null) {
		$query = "
			SELECT a.announce_id, a.announce_title, a.announce_create_datetime, 
			i.identity_nic, a.user_id, i.identity_id 
			FROM " . $this->db->prefix . "_announce a, " . $this->db->prefix . "_user_identity i
			WHERE a.user_id=i.user_id AND i.identity_type=2 "
		;

		if (isset($this->order_by)) {
			$query .= "ORDER BY " . $this->order_by;
		}
		else {
			$query .= "ORDER BY a.announce_create_datetime DESC";
		}

		$result = $this->db->Execute($query);
		$temp = array();
		$counter = 0;
		if (isset($result->fields)) {			
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
				$counter++;
				if ($counter >= $nr && isset($nr)) {
					break;
				}
			}
			$result->Close();
		}
		else {
			$error_info = "function=selAnnouncements class=Announce.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		return $temp;		
		
	}//EO selAnnouncements	
	
	
	// deleteAnnouncement
	// deletes a row in the database
	// Sebastian Oblom, 6th October 2006
	//
	function deleteAnnouncement($announce_id) {
		$query = "
			DELETE from " . $this->db->prefix . "_announce
			WHERE announce_id=" . $announce_id
		;
		
		$result = $this->db->Execute($query);
		if (!isset($result->fields)) {
			$error_info = "function=delete class=Announce.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO deleteAnnouncement
	
	
	// update
	// updates a record in the database
	// Sebastian Oblom, 6th October 2006
	//
	function updateRecord($data) {
		$query = "
			SELECT announce_id, announce_title, announce_body, user_id, language_id, announce_create_datetime
			FROM " . $this->db->prefix . "_announce 
			WHERE announce_id=" . $data['announce_id']
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['announce_id']              = $result->fields['announce_id'];
			$rec['announce_title']           = $data['announce_title'];
			$rec['announce_body']            = $data['announce_body'];
			$rec['user_id']                  = $this->user_id;
			$rec['language_id']              = $_SESSION['language_id'];
			$rec['announce_edit_datetime']   = time();
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (!isset($result->fields)) {
				$error_info = "function=updateRecord class=Announce.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
		}
		else {
			$error_info = "function=updateRecord class=Announce.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO updateRecord
}

?>