<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (!isset($_SESSION['md5'])) {
	header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
	exit;
}


if (!empty($_POST) & !empty($_POST['message_ids'])) {

	if (!empty($_POST['mark_read'])) {
		$im->setMessagesStatus($_POST['message_ids'], $core_config['messaging']['status']['read']);
		header("Location: index.php?amn=core_msg_view&".$_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
	elseif (!empty($_POST['mark_unread'])) {
		$im->setMessagesStatus($_POST['message_ids'], $core_config['messaging']['status']['unread']);
		header("Location: index.php?amn=core_msg_view&".$_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
	elseif (!empty($_POST['delete'])) {
		$im->deleteMessages($_POST['message_ids']);
		header("Location: index.php?amn=core_msg_view&". $_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
}

// setup boxes
$im->box = $core_config['messaging']['box']['in']; // default

if (isset($_REQUEST['box'])) {
	if (in_array($_REQUEST['box'], $core_config['messaging']['box'])) {
		$im->box = $_REQUEST['box'];
	}
}

// tell the menu which box we are looking at
$tpl->set('message_box', $im->box);
$body->set('message_box', $im->box);

$output_messages = $im->selMessages();

// add identities to messages
if (!empty($output_messages)) {
	foreach ($output_messages as $key => $i):
		$output_messages[$key]['from_identity'] = $user->selUserIdentity(null, $i['from_identity_id']);
		$output_messages[$key]['to_identity'] = $user->selUserIdentity(null, $i['to_identity_id']);
	endforeach;
}


// statistics
$output_message_statistics = array();
$output_message_statistics[$core_config['messaging']['box']['in']] = $im->messageCount($core_config['messaging']['box']['in'], 'to_identity_id');
$output_message_statistics[$core_config['messaging']['box']['out']] = $im->messageCount($core_config['messaging']['box']['out'], 'from_identity_id');
$body->set('message_statistics', $output_message_statistics);


$body->set('messages', $output_messages);
$body->set('messaging_config', $core_config['messaging']);
$body->set('message_allocation', $im->message_allocation);



?>