<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


include dirname(__FILE__) . "/../components/core/config/aroundme_core.config.php";
include "config/batch.config.php";


// SETUP DATABASE --------------------------------------------------------
require_once(dirname(__FILE__) . '/../components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($core_config['db']['driver']);
if ($db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	$db->prefix = $core_config['db']['prefix'];
	
	
	$chart           = ImageCreate($batch_config['30_day_activity']['width'], $batch_config['30_day_activity']['height']);
	$backgroundcolor = ImageColorAllocate($chart, $batch_config['30_day_activity']['color']['grids_background']['red'], $batch_config['30_day_activity']['color']['grids_background']['green'], $batch_config['30_day_activity']['color']['grids_background']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $batch_config['30_day_activity']['color']['grids']['red'], $batch_config['30_day_activity']['color']['grids']['green'], $batch_config['30_day_activity']['color']['grids']['blue']);
	$gridscolor_bg   = ImageColorAllocate($chart, $batch_config['30_day_activity']['color']['grids_background']['red'], $batch_config['30_day_activity']['color']['grids_background']['green'], $batch_config['30_day_activity']['color']['grids_background']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $batch_config['30_day_activity']['color']['foreground']['red'], $batch_config['30_day_activity']['color']['foreground']['green'], $batch_config['30_day_activity']['color']['foreground']['blue']);
	$chart_bg = ImageColorAllocate($chart, $batch_config['30_day_activity']['color']['background']['red'], $batch_config['30_day_activity']['color']['background']['green'], $batch_config['30_day_activity']['color']['background']['blue']);
	$y_values        = array(); $i=0;
	
	while($i < 30) { // we need to init $y_values
		array_push($y_values, array('x' => ++$i, 'y' => 0));
	}
	
	// select some values from the database -----------------------------------------------------
	$query = "
		SELECT COUNT(distinct user_id) AS y, DAY(session_lastused) AS x
		FROM " . $db->prefix . "_user_session 
		GROUP BY DAY(session_lastused) ORDER BY session_lastused DESC
		LIMIT 30"
	;

	$result = $db->Execute($query);

	if (isset($result->fields)) {
		$counter = $max_val = 0;
		while(!$result->EOF) {
			$y_values[$counter] = $result->fields;
			$max_val = $max_val >= $result->fields['y'] ? $max_val : $result->fields['y'];
			$result->moveNext();
			$counter++;
		}
		$result->Close();
	}
	// ------------------------------------------------------------------------------------------
	
	$s = $batch_config['30_day_activity']['pile_scale'] * $batch_config['30_day_activity']['height'] / $max_val;
	imagefilledrectangle($chart, $batch_config['30_day_activity']['padding']['left']+1, 0, $batch_config['30_day_activity']['width'], $batch_config['30_day_activity']['height'] - 2*$batch_config['30_day_activity']['padding']['bottom'], $chart_bg);
	
	for($i = 0; $i < count($y_values); $i++) {
		$x1 = $i * $batch_config['30_day_activity']['pile_space'] + $batch_config['30_day_activity']['padding']['left'];
		$y1 = $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top']  - $batch_config['30_day_activity']['padding']['bottom']- intval($y_values[$i]['y'] * $s);
		$x2 = $i * $batch_config['30_day_activity']['pile_space'] + $batch_config['30_day_activity']['pile_width'] + $batch_config['30_day_activity']['padding']['left'];
		$y2 = $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'];
		imagefilledrectangle($chart, $x1, $y1, $x2, $y2, $foregroundcolor);
	}
	
// 	imagefilledrectangle($chart, 0, 0, $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['height'], $gridscolor_bg);
// 	imagefilledrectangle($chart, 0, $batch_config['30_day_activity']['height'] - 2*$batch_config['30_day_activity']['padding']['bottom'], $batch_config['30_day_activity']['width'], $batch_config['30_day_activity']['height'], $gridscolor_bg);
	
	
	imageline($chart, $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'], $batch_config['30_day_activity']['width'] - $batch_config['30_day_activity']['padding']['right'], $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'], $gridscolor);
	for($i=0; $i <= 30; $i += 5){
		imageline($chart, ($i-1) * $batch_config['30_day_activity']['pile_space'] + 3, $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'], ($i-1) * $batch_config['30_day_activity']['pile_space'] + 3, $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'] -3, $gridscolor);
		imagestring($chart, 0, ($i-1) * $batch_config['30_day_activity']['pile_space'] + 1, $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'] + 1, - $i, $gridscolor);
	}
	
	imageline($chart, $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['padding']['top'], $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['height'] - $batch_config['30_day_activity']['padding']['top'] - $batch_config['30_day_activity']['padding']['bottom'], $gridscolor);
	imageline($chart, $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['padding']['top'], $batch_config['30_day_activity']['padding']['left'] + 5, $batch_config['30_day_activity']['padding']['top'], $gridscolor);
	imageline($chart, $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['height'] / 2, $batch_config['30_day_activity']['padding']['left'] + 3, $batch_config['30_day_activity']['height'] / 2, $gridscolor);
	imagestring($chart, 0, 2, $batch_config['30_day_activity']['padding']['top'], intval($max_val/0.75), $gridscolor);
	imagestring($chart, 1, $batch_config['30_day_activity']['padding']['left'], $batch_config['30_day_activity']['height'] - 10, date('Y-m-d h:i:s'), $gridscolor);
	
	imagepng($chart, $batch_config['30_day_activity']['name']); 
	ImageDestroy($chart);
}

?>