// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

/**
 * Some of these scripts have been customised from MediaWiki and phpBB source. Original authors were:
 * @author Andreas Gohr <andi@splitbrain.org>
 * @author Jim Raynor <jim_raynor@web.de>
 */

/**
 * Some browser detection
 */
var clientPC  = navigator.userAgent.toLowerCase(); // Get client info
var is_gecko  = ((clientPC.indexOf('gecko')!=-1) && (clientPC.indexOf('spoofer')==-1)
                && (clientPC.indexOf('khtml') == -1) && (clientPC.indexOf('netscape/7.0')==-1));
var is_safari = ((clientPC.indexOf('AppleWebKit')!=-1) && (clientPC.indexOf('spoofer')==-1));
var is_khtml  = (navigator.vendor == 'KDE' || ( document.childNodes && !document.all && !navigator.taintEnabled ));
if (clientPC.indexOf('opera')!=-1) {
    var is_opera = true;
    var is_opera_preseven = (window.opera && !document.childNodes);
    var is_opera_seven = (window.opera && document.childNodes);
}





/**
 * apply tagOpen/tagClose to selection in textarea
 */
function insertTags(id, txtarea, preset) {
	
	var txtarea = document.getElementById(txtarea);
	
	// bold
	if (id=='b') {
		tagOpen = '<b>';
		tagClose = '</b>';
		sampleText = 'Bold Text';
	}
	
	// italic
	if (id=='i') {
		tagOpen = '<i>';
		tagClose = '</i>';
		sampleText = 'Italic Text';
	}	
	
	// headline 1
	if (id=='h1') {
		tagOpen = '\n<h1>';
		tagClose = '</h1>\n';
		sampleText = 'Headline';
	}
	
	// headline 2
	if (id=='h2') {
		tagOpen = '\n<h2>';
		tagClose = '</h2>\n';
		sampleText = 'Headline';
	}
	
	// headline 3
	if (id=='h3') {
		tagOpen = '\n<h3>';
		tagClose = '</h3>\n';
		sampleText = 'Headline';
	}
	
	// headline 4
	if (id=='h4') {
		tagOpen = '\n<h4>';
		tagClose = '</h4>\n';
		sampleText = 'Headline';
	}
	
	// headline 5
	if (id=='h5') {
		tagOpen = '\n<h5>';
		tagClose = '</h5>\n';
		sampleText = 'Headline';
	}
	
	// teletype
	if (id=='tt') {
		tagOpen = '<tt>';
		tagClose = '</tt>';
		sampleText = 'Teletype text';
	}
	
	// code
	if (id=='code') {
		tagOpen = '\n<code>\n';
		tagClose = '\n</code>\n';
		sampleText = 'Code';
	}
	
	// ordered list
	if (id=='ol') {
		tagOpen = '<ol>\n    <li>';
		tagClose = '</li>\n</ol>\n';
		sampleText = 'Ordered list item';
	}
	
	// unordered list
	if (id=='ul') {
		tagOpen = '<ul>\n    <li>';
		tagClose = '</li>\n</ul>\n';
		sampleText = 'Unordered list item';
	}
	
	// colour
	if (id=='color') {
		if (preset) {
			tagOpen = '<span style="color : '+preset+';">';
			tagClose = '</span>';
			sampleText = 'Coloured text';
		}
		else {
			tagOpen = '##red|';
			tagClose = '##';
		}
		
		sampleText = 'Coloured text';
	}
	
	// Horizontal rule
	if (id=='hr') {
		tagOpen = '----\n';
		tagClose = '';
		sampleText = 'Horizontal rule';
	}
	
	// Wiki Image
	if (id=='image' && preset != '') {
		tagOpen = '<img src="get_file.php?file='+preset+'" alt="';
		tagClose = '" />';
		sampleText = 'Image description';
	}
	
	// Wiki File
	if (id=='file' && preset != '') {
		// we explode the preset to gain the type (for the icon)
		var preset_array=preset.split("-");
		
		tagIcon = '';
		
		if (preset_array[3] != '') {
			var preset_file=preset_array[3].split("/");
		}
		
		if (preset_file[1] != '') {
			
			tagIcon = '<p><a href="get_file.php?file='+preset+'"><img src="'+baseImgURL+'file_'+preset_file[1]+'.png" border="0" /></a>&nbsp;';
		}
		
		tagOpen = tagIcon+'<a href="get_file.php?file='+preset+'">';
		
		if (preset_file[1] != '') {
			tagClose = '</a></p>';
		}
		else {
			tagClose = '</a>';
		}
		
		sampleText = 'File description';
	}
  
  // IE
  if(document.selection  && !is_gecko) {
    var theSelection = document.selection.createRange().text;
    var replaced = true;
    if(!theSelection){
      replaced = false;
      theSelection=sampleText;
    }
    txtarea.focus();
 
    // This has change
    text = theSelection;
    if(theSelection.charAt(theSelection.length - 1) == " "){// exclude ending space char, if any
      theSelection = theSelection.substring(0, theSelection.length - 1);
      r = document.selection.createRange();
      r.text = tagOpen + theSelection + tagClose + " ";
    } else {
      r = document.selection.createRange();
      r.text = tagOpen + theSelection + tagClose;
    }
    if(!replaced){
      r.moveStart('character',-text.length-tagClose.length);
      r.moveEnd('character',-tagClose.length);
    }
    r.select();
  // Mozilla
  } else if(txtarea.selectionStart || txtarea.selectionStart == '0') {
    var replaced = false;
    var startPos = txtarea.selectionStart;
    var endPos   = txtarea.selectionEnd;
    if(endPos - startPos) replaced = true;
    var scrollTop=txtarea.scrollTop;
    var myText = (txtarea.value).substring(startPos, endPos);
    if(!myText) { myText=sampleText;}
    if(myText.charAt(myText.length - 1) == " "){ // exclude ending space char, if any
      subst = tagOpen + myText.substring(0, (myText.length - 1)) + tagClose + " ";
    } else {
      subst = tagOpen + myText + tagClose;
    }
    txtarea.value = txtarea.value.substring(0, startPos) + subst +
                    txtarea.value.substring(endPos, txtarea.value.length);
    txtarea.focus();
 
    //set new selection
    if(replaced){
      var cPos=startPos+(tagOpen.length+myText.length+tagClose.length);
      txtarea.selectionStart=cPos;
      txtarea.selectionEnd=cPos;
    }else{
      txtarea.selectionStart=startPos+tagOpen.length;   
      txtarea.selectionEnd=startPos+tagOpen.length+myText.length;
      txtarea.scrollTop=scrollTop;
    }
  // All others
  } else {
    var copy_alertText=alertText;
    var re1=new RegExp("\\$1","g");
    var re2=new RegExp("\\$2","g");
    copy_alertText=copy_alertText.replace(re1,sampleText);
    copy_alertText=copy_alertText.replace(re2,tagOpen+sampleText+tagClose);
    var text;
    if (sampleText) {
      text=prompt(copy_alertText);
    } else {
      text="";
    }
    if(!text) { text=sampleText;}
    text=tagOpen+text+tagClose;
    //append to the end
    txtarea.value += "\n"+text;

    // in Safari this causes scrolling
    if(!is_safari) {
      txtarea.focus();
    }

  }
  // reposition cursor if possible
  if (txtarea.createTextRange) txtarea.caretPos = document.selection.createRange().duplicate();
}























