<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


if ($_SESSION['user_core_permission'] & $core_config['resource']['user']['maintainer']) {
	
	//setup useradmin (extends user)
	require_once('class/User.class.php');
	require_once('class/UserAdmin.class.php');
	$user = new UserAdmin($db, $core_config['user']);
	
	if (isset($_POST['update_user'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_user 
			WHERE 
			user_id=" . $_POST['user_id']
		;
			
		$result = $db->Execute($query);
		
		$rec = array();
		$rec['language_id'] = $_POST['language_id'];
		$rec['status_id'] = $_POST['status_id'];
		$rec['membership_type_id'] = $_POST['membership_type_id'];
		
		if (!empty($_POST['role_id'])) {
			$rec['role_id'] = $_POST['role_id'];
		}
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		
		// set the allocations
		$query = "
			DELETE FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $_POST['user_id'] . " AND 
			(item_type=". $core_config['file']['allocation']['type']['user'] . " OR 
			item_type=". $core_config['file']['allocation']['type']['message'] . ") AND 
			module_id=0"
		;
		
		$result = $db->Execute($query);
		
		// insert new alloctions
		$table = $db->prefix . "_file_allocation";
		
		$rec = array();
		$rec['item_id'] = $_POST['user_id'];
		$rec['module_id'] = 0;
		
		$rec['item_type'] = $core_config['file']['allocation']['type']['user'];
		$rec['file_allocation'] = $_POST['user_file_allocation']*1000;
		
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		$rec['item_type'] = $core_config['file']['allocation']['type']['message'];
		$rec['file_allocation'] = $_POST['user_message_allocation']*1000;
		
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);

		if ($_SESSION['user_id'] == $_POST['user_id']) {
			if (!empty($_POST['role_id'])) {
				$_SESSION['role_id'] = $_POST['role_id'];
			}
			else {
				unset($_SESSION['role_id']);
			}

			$_SESSION['membership_type_id'] = $_POST['membership_type_id'];
		}	
		
	}
	elseif (isset($_POST['update_permissions'])) {
		$data['user_id'] = $_POST['user_id'];
		
		$data['user_core_permission'] = 0;
		
		if (!empty($_POST['permission']['user'])) {
			foreach($_POST['permission']['user'] as $key => $i):
				$data['user_core_permission'] = $data['user_core_permission'] + $i;
			endforeach;
		}
		
		$data['user_mod_permission'] = 0;
		
		if (!empty($_POST['permission']['mod'])) {
			foreach($_POST['permission']['mod'] as $key => $i):
				$data['user_mod_permission'] = $data['user_mod_permission'] + $i;
			endforeach;
		}
		
		$user->updateUserPermissions($data);

		if ($_SESSION['user_id'] == $_POST['user_id']) {
			$_SESSION['user_core_permission'] = $data['user_core_permission'];
			$_SESSION['user_mod_permission'] = $data['user_mod_permission'];
		}
	}
	
	
	if (isset($_REQUEST['user_id'])) {
		$user->user_id = $_REQUEST['user_id'];
		
		$output_user = $user->selUser();
		
		$body->set('user', $output_user);
		
		// IDENTITY
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->user_id = $_SESSION['user_id'];
		$file->module_id = 0; // core
		
		if (isset($core_config['module'])) {
			$file->core_config_module = $core_config['module'];
		}
		
		$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		
		$user->file = $file;
		
		$output_identity = $user->selUserIdentity($_REQUEST['user_id'], null, 1);
		$body->set("identity", $output_identity);
		
		
		//RESOURCES
		$body->set('user_resources', $core_config['resource']['user']);
		
		if (!empty($core_config['resource']['module'])) {
			$body->set('module_resources', $core_config['resource']['module']);
		}
		
		
		// PERMISSIONS
		$output_user = $user->selUser($output_identity['user_id']);
		
		// ALLOCATIONS
		$output_user['user_file_allocation'] = "0";
		
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $output_identity['user_id'] . " AND 
			item_type=". $core_config['file']['allocation']['type']['user'] . " AND 
			module_id=0"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_user['user_file_allocation'] = $result->fields['file_allocation'];
		}
		
		$output_user['user_message_allocation'] = "0";
		
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $output_identity['user_id'] . " AND 
			item_type=". $core_config['file']['allocation']['type']['message'] . " AND 
			module_id=0"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_user['user_message_allocation'] = $result->fields['file_allocation'];
		}
		

		$body->set('user', $output_user);
	}
	
	
}
else {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}
?>