<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



// setup useradmin (extends user)
require_once('class/User.class.php');
require_once('class/UserAdmin.class.php');
$user = new UserAdmin($db, $core_config['user']);


//form processing
if (isset($_POST['setup'])) {
	// verify form data	
	if(empty($_POST['user_firstname'])) {
		$GLOBALS['am_error_log'][] = array('firstname_empty');
	}
	
	// Check the surname
	if(empty($_POST['user_surname'])) {
		$GLOBALS['am_error_log'][] = array('surname_empty');
	}
	
	// Check the nic
	if(empty($_POST['user_nic'])) {
		$GLOBALS['am_error_log'][] = array('nickname_empty');
	}
	
	// Check the place of residence
	if(isset($_POST['location_id']) && (empty($_POST['location_id']) || $_POST['location_id'] < 1)) {
		$GLOBALS['am_error_log'][] = array('location_empty');
	}
	
	$output_user = $user->selUser($_POST['user_id']);
	
	//check the access code
	$query = "
		SELECT user_id 
		FROM " . $db->prefix . "_user
		WHERE
		user_id=" . $_POST['user_id'] . " AND
		user_password=" . $db->qstr(MD5($_POST['access_code']), get_magic_quotes_gpc())
	;
	
	$result = $db->Execute($query);
	
	if(!isset($result->fields['user_id']) || $result->fields['user_id'] < 0) {
		$GLOBALS['am_error_log'][] = array('access_code_wrong');
	}
	
	if(isset($_POST['user_password1']) && isset($_POST['user_password2']) && $_POST['user_password1'] != $_POST['user_password2']) {
		$GLOBALS['am_error_log'][] = array('password_mismatch');
	}

	if(isset($_POST['user_password1']) && strlen($_POST['user_password1']) < 5) {
		$GLOBALS['am_error_log'][] = array('password_wrong');
	}
	
	$_POST['user_dob'] = $_POST['year']."-".$_POST['month']."-".$_POST['day'];
	
	// Check the date of birth
	if(empty($_POST['user_dob']) || $_POST['user_dob'] == "1900-01-01") {
		$GLOBALS['am_error_log'][] = array('dob_wrong');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		$output_user = $user->selUser($result->fields['user_id']);
		
		//setup instant messaging
		$core_config['messaging']['file']['allocation'] = $core_config['file']['allocation'];
		
		require_once('class/Message.class.php');
		$im = new Message($output_user['user_id'], $db, $core_config['messaging']);
		$user->im = $im;
		
		$user->body_welcome_txt = readTxtFile($language_path . "texts/im_welcome.txt.php");
		$user->subject_im_welcome = $lang['subject_im_welcome'];
		
		$user->body_join_txt = readTxtFile($language_path . "texts/im_join.txt.php");
		$user->subject_im_join = $lang['subject_im_join'];
		$user->href_join = $lang['href_join'];
		
		if (isset($lang['arr_module'])) {
			$user->module_titles = $lang['arr_module'];
		}
		
		$user->config['file']['allocation'] = $core_config['file']['allocation'];
		$user->user_firstname = $output_user['user_firstname'];
		$user->user_email = $output_user['user_email'];
		$user->language_id = $output_user['language_id'];
		
		$user->subject_im_joined = $lang['subject_im_joined'];
		
		$user->identity_types = $lang['identity']['type'];
		
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, $core_config['statistic']);
		$statistic->module_id = 0; // core
		$user->statistic = $statistic;
		
		$user->default_role_id = $core_config['membership_type']['invite_default'];
		
		$user->user_image_allocation = $core_config['file']['allocation']['default_user'];
		$user->user_message_allocation = $core_config['file']['allocation']['default_message'];
		
		require_once('components/core/class/Participation.class.php');
		$participation = new Participation($db, $core_config);
		$user->participation = $participation;

		if (empty($GLOBALS['am_error_log']) && !empty($_FILES['frm_file']['tmp_name'])) {
			require_once ("class/File.class.php");
			$file = new File($db, $core_config['file']);
			$file->user_id = $output_user['user_id'];
			$file->module_id = 0; // core
			$file->file_allocation = $core_config['file']['allocation']['default_user'];
			
			if (isset($core_config['module'])) {
				$file->core_config_module = $core_config['module'];
			}
			
			$file->skipAllocationCheck = 1;
			
			$file->setFile($_FILES['frm_file']);
			
			if ($file->isOk()) {
				$file->max_width = $core_config['file']['image']['thumb'][0]['width'];
				$file->max_height = $core_config['file']['image']['thumb'][0]['height'];
				$file->uploadFile();
				$file->createThumbNails();
			}
		}
				
				
		if (empty($GLOBALS['am_error_log'])) {
			$user->setupUser($_POST);
		}
				
		// we update the identity 
		if (empty($GLOBALS['am_error_log']) && isset($file->file_id, $user->identity_id)) {
			
			$query = "
				SELECT * FROM " . $db->prefix . "_user_identity 
				WHERE 
				identity_id = " . $user->identity_id
			;

			$result = $db->SelectLimit($query, 1);
			
			if (isset($result)) {
				$rec = array();
				$rec['file_id'] = $file->file_id;
				
				$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
		}
		
		
		if (empty($GLOBALS['am_error_log'])) {
			$user->loginUser($output_user['user_email'],$_POST['user_password1']);
		}
	}
	else { //return vars to form
		$body->set('datedropdown', $date->dateDropdown($_POST['user_dob']));
	
		$body->set('display', "setup");
	}
}
elseif (isset($_REQUEST['em'])) { //the account page
	//get user
	$user->user_email = $_REQUEST['em'];
	$output_user = $user->selUser();
}



if (isset($output_user['status_id']) && $output_user['status_id'] == $core_config['user']['status']['pending']) { //we can set up
	// get locations
	$output_locations = $user->selLocations($output_user['language_id']);
	
	if (!empty($output_locations)) {
		$body->set('locations', $output_locations);
	}
	
	// append user preferences to language array
	require_once($language_path . 'inc/user_preferences.inc.php');
	// unset options not neccesary for setup
	unset($lang['user']['preference'][$core_config['user']['preference']['comment_list_view']]);
	// if no cron remove cron based preferences
	if (!isset($core_config['batch']['enabled']) || $core_config['batch']['enabled'] != true) {
		unset($lang['user']['preference'][$core_config['user']['preference']['digest_newsletter']]);
	}
	
	// fill in some hidden form files
	$_POST['user_id'] = $output_user['user_id'];
	$_POST['user_firstname'] = $output_user['user_firstname'];
	
	if (!isset($body->datedropdown)) {
		$body->set('datedropdown', $date->dateDropdown());
	}
	
	$body->set('display', "setup");
}

?>
