// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



function initColourPicker(id, columns) {
	var colours = Array(
 		'#FFFFFF', '#EDEDED', '#E4E4E4', '#DADADA', '#D1D1D1',
		'#C7C7C7', '#BDBDBD', '#B3B3B3', '#A8A8A8', '#9E9E9E',
		'#FF0010', '#FFFE38', '#76FF36', '#00FFFF', '#002CFD',
		'#EF00FD', '#FB0034', '#FFF125', '#00AE5F', '#00B8EF',
		'#00429A', '#F30094', '#939393', '#878787', '#7B7B7B',
		'#6E6E6E', '#626262', '#535353', '#444444', '#343434',
		'#202020', '#000000', '#FF9C86', '#FFB18D', '#FFC997',
		'#FFF7A4', '#D8E2A6', '#B5D8A6', '#91CFA6', '#78D3CD',
		'#08D6F7', '#63AFDA', '#709DCE', '#7D8CC2', '#9D90C2',
		'#F8A1C6', '#FE9EA5', '#FF715C', '#FF9363', '#FFB26A',
		'#FFF478', '#C3D680', '#96C981', '#55BF84', '#00C3BB',
		'#00C7F3', '#0097CE', '#0080BC', '#416AAD', '#7E6BAF',
		'#A66EAF', '#F475AF', '#FB7388', '#FB0034', '#FF6A35',
		'#FF9936', '#FFF125', '#ADCB52', '#62BC5B', '#00AE5F',
		'#00B2A6', '#00B8EF', '#0080C1', '#0063AB', '#00429A',
		'#593C99', '#923397', '#F30094', '#F90066', '#AD001F',
		'#B34A20', '#B76B21', '#C4A621', '#748F3B', '#408641',
		'#007E46', '#008076', '#0083AB', '#005A89', '#00437B',
		'#00256E', '#421E6C', '#68006B', '#A90068', '#AC0047',
		'#8A0000', '#8D3A00', '#905400', '#998402', '#58712A',
		'#2E6B31', '#006535', '#00665E', '#006988', '#00456D',
		'#003162', '#000258', '#2F0056', '#540054', '#870052',
		'#8A0035', '#D3B7A1', '#A88E80', '#816E64', '#625550',
		'#463D3B', '#D6A279', '#B8855E', '#9E6D49', '#875735',
		'#744524')
	;
				
	colourPicker(columns,colours.length, colours, id);
}



function colourPicker(num_rows, total_cells, colours, id) {
	var root = document.getElementById(id);
	var table = document.createElement('table');
	table.id = 'swatch';
	root.appendChild(table);
	var tbody = document.createElement('tbody');
	var tr = document.createElement('tr');
	tbody.appendChild(tr);
	table.appendChild(tbody);
	var row = tr;
	
	for(var i = 0; i < total_cells; i++){
		if( (i != 0) && ( i % num_rows ) == 0) {
			row = tbody.appendChild(document.createElement('tr'));
		} 
		
		td = document.createElement('td')
		td.width = 6;
		td.height = 4;
		td.id = colours[i];
		td.onclick = setcolour;
		td.style.background = colours[i];
		
		row.appendChild(td);
	}
	
	tfoot = document.createElement('tfoot');
	return table;
}
	
	
function setcolour() {
	var swatch = document.getElementById(this.id);
	//var input = document.getElementById(inputfield);
	var input = document.getElementById(inputfield);
	input.value = swatch.id;
	input.style.color = swatch.id;
	updateVisualiser();
}
	 