<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if (isset($module_id)) {
	$output_item['module_id'] = $module_id;
}



if (isset($_POST['my_participation_update'])) {
	// update my identity
	$query = "
		SELECT user_id, identity_id 
		FROM " . $db->prefix . "_participation 
		WHERE 
		item_id=" . $output_item['item_id'] . " AND 
		module_id=" . $output_item['module_id'] . " AND 
		user_id=" . $_SESSION['user_id']
	;
	
	$result = $db->Execute($query);
		
	if (isset($result->fields)) {
		$rec = array();
		
		if (!empty($_POST['identity_id'])) {
			$rec['identity_id'] = $_POST['identity_id'];
		}
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);	
		
		$output_participation['identity_id'] = $_POST['identity_id'];
	}
}
elseif (isset($_POST['my_participation_withdraw'])) {
	// set my status to withdrawn

}
elseif (isset($_POST['update_user_participation'])) {
	
	$query = "
		SELECT user_id, status_id, identity_id, participation_permission, 
		participation_create_datetime, role_id 
		FROM " . $db->prefix . "_participation 
		WHERE 
		item_id=" . $output_item['item_id'] . " AND 
		module_id=" . $output_item['module_id'] . " AND 
		user_id=" . $_POST['user_id']
	;
	
	$result = $db->Execute($query);
		
	if (isset($result->fields)) {
		$rec = array();
		
		if (!empty($_POST['status_id'])) {
			$rec['status_id'] = $_POST['status_id'];
		}
		
		if ($_SESSION['user_id'] == $output_item['user_id']) {
			$rec['role_id'] = "null";
			
			if (!empty($_POST['coordinator'])) {
				$rec['role_id'] = $core_config['module_user']['role']['coordinator'];
			}
			
			if (isset($_POST['permission']['item_user'])) {
				$permission_count = "0";
				
				foreach ($_POST['permission']['item_user'] as $key => $i):
					$permission_count = $permission_count+$i;
				endforeach;
				
				$rec['participation_permission'] = $permission_count;
			}
		}
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);	
		
		$_REQUEST['identity_id'] = $_POST['user_identity_id'];
	
	}
}
elseif (isset($_POST['delete_relations'])) {
	$participation->deleteRelations($_POST['identity_ids'], $output_participation['identity_id']);
}
elseif (isset($_POST['sub_set_hold'])) {
	$participation->setUserStatus($_POST['identity_ids'], $core_config['module_user']['status']['hold']);
	unset($_REQUEST['identity_id']);
}
elseif (isset($_POST['sub_set_barred'])) {
	$participation->setUserStatus($_POST['identity_ids'], $core_config['module_user']['status']['barred']);
	unset($_REQUEST['identity_id']);
}
elseif (isset($_POST['sub_set_active'])) {
	$participation->setUserStatus($_POST['identity_ids'], $core_config['module_user']['status']['active']);
	unset($_REQUEST['identity_id']);
}



// CREATE SUMMARY --------------------------------------------------------
// if we can edit status we create a set of items per status, otherwise we summarise
if (isset($output_item['allow_user_manage'])) {
	foreach($core_config['module_user']['status'] as $key => $i):
		$tmp = $participation->countParticipants($i);
		$output_summary['status'][$i] = $tmp;
	endforeach;
}
else {
	$output_summary['status'][$core_config['module_user']['status']['active']] = $participation->countParticipants($core_config['module_user']['status']['active']);
}

// relations within item
$output_summary['relations'] = $participation->countRelations($output_participation['identity_id']);
$output_summary['coordinators'] = $participation->countParticipants(null, $core_config['module_user']['role']['coordinator']);

$body->set('summary', $output_summary);



// SELECT PARTICIPANTS --------------------------------------------------------
if (!empty($_REQUEST['list']) && $_REQUEST['list'] == "participants") {
	$output_participants = $participation->selParticipants($core_config['module_user']['status']['active']);
}
elseif (!empty($_REQUEST['list']) && $_REQUEST['list'] == "coordinators") {
	$output_participants = $participation->selParticipants(null, $core_config['module_user']['role']['coordinator']);
}
elseif (!empty($_REQUEST['status_id'])) {
	$output_participants = $participation->selParticipants($_REQUEST['status_id']);
}
else { // list relations
	$output_relations = $participation->selRelations($output_participation['identity_id']);
	
}



// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
if (!empty($output_participants)) {
	// get their ids
	if (!empty($output_participants)) {
		foreach ($output_participants as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the participants
			if (!empty($output_identities)) {
				foreach ($output_participants as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id'] == $i['identity_id']) {
							$output_participants[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
			
			$body->set('participants', $output_participants);
		}
	}
}


if (!empty($output_relations)) {
	// get their ids
	unset($user->identity_ids, $user->user_id);
	
	if (!empty($output_relations)) {
		foreach ($output_relations as $key => $i):
			$user->identity_ids[] = $i['identity_id_relation'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			$body->set('relations', $output_identities);
		}
	}
}


// get user identities
$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
$body->set('identities', $output_identities);



// SELECT USER
if (isset($_REQUEST['identity_id']) && !empty($output_item['allow_user_manage'])) {
	$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
	
	if (!empty($output_participant)) {
		
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->user_id = $_SESSION['user_id'];
		$file->module_id = 0; // core
		$file->directory = "core";
		$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
		$user->file = $file;
		
		$output_participant['identity'] = $user->selUserIdentity(null, $output_participant['identity_id']);
		
		$body->set('participant', $output_participant);
		
		// if we are the group owner we select coordinators 
		if (($output_participant['user_id'] == $output_item['user_id']) && ($_SESSION['user_id'] == $output_item['user_id'])) { // group owner only
			
			$output_coordinators = $participation->selParticipants(null, $core_config['module_user']['role']['coordinator']);
			
			if (!empty($output_coordinators)) {
				foreach ($output_coordinators as $key => $i):
					$user->identity_ids[] = $i['identity_id'];
				endforeach;
				
				$user->identity_ids = array_unique($user->identity_ids);
				
				if (!empty($user->identity_ids)) {
					$output_identities = $user->selUserIdentities();
					
					// we place the identities against the participants
					if (!empty($output_identities)) {
						foreach ($output_coordinators as $keyp => $p):
							foreach ($output_identities as $keyi => $i):
								if ($p['identity_id'] == $i['identity_id']) {
									$output_coordinators[$keyp]['identity'] = $i;
									break;
								}
							endforeach;
						endforeach;
					}
					
					$body->set('coordinators', $output_coordinators);
				}
			}
		}
		
	}
}





// move to templates
$tpl->set('item', $output_item);
$body->set('item', $output_item);
$body->set('participation', $output_participation);
$body->set('module_user', $core_config['module_user']);


?>
