<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (isset($_SESSION['md5'])) {
	header("Location: index.php?amn=core_" . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

//set up user
require_once('components/core/class/User.class.php');
$user = new User($db, $core_config['user']);

if (isset($_REQUEST['nem']) && isset($_REQUEST['ac'])) {
	// the user has requested that we change their email to a new email
	$query = "
		SELECT user_id, user_email, user_email_new, user_password 
		FROM " . $db->prefix . "_user
		WHERE 
		user_email_new=" . $db->qstr($_REQUEST['nem'], get_magic_quotes_gpc())
	;

	$result = $db->Execute($query);

	if (isset($result)) {
		$temp_access_code = md5($result->fields['user_password']);
		$temp_access_code = substr($temp_access_code, 0, 6);
		
		if (($_REQUEST['nem'] == $result->fields['user_email_new']) && ($_REQUEST['ac'] == $temp_access_code)) {
			// we change the email
			$rec = array();
			$rec['user_email'] = $result->fields['user_email_new'];
			$rec['user_email_new'] = "null";
		
			$table = $db->prefix . "_user";
		
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			$email_change_status = "email_changed";
		}
	}
	
	if (!isset($email_change_status)) {
		$email_change_status = "email_not_changed";
	}
	
	$body->set('email_change_status', $email_change_status);

}
elseif (isset($_POST['login'])) {

	if (isset($_POST['email']) && $_POST['email'] && isset($_POST['password']) && $_POST['password']) {
		//$user->relation_type = $core_config['user']['relation_type']['approved'];

		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, $core_config['statistic']);
		$statistic->module_id = 0; // core
		$user->statistic = $statistic;

		$user->checkLogin($_POST['email'],$_POST['password']);
	
		if (empty($GLOBALS['am_error_log'])) {
			if (isset($_POST['http_referer'])) {
			    $user->http_referer = $_POST['http_referer'];
			}
			
			$user->loginUser($_REQUEST['email'],$_REQUEST['password']);

		}
	}
	else {
		$GLOBALS['am_error_log'][] = array('login_error');
	}
}
elseif (isset($_REQUEST['dormant'])) {
	// the user has set their account to be dormant
	// they can type in their email and dob to re-active the account.
	// They will be sent a new password.
	$body->set('datedropdown', $date->dateDropdown());
	
	$body->set('display', 'dormant');
}
elseif (isset($_POST['activate'])) {
	// the user has set their account to be dormant. We will check user_id and
	// dob, if correct we set status_id to active and log them in
	// Checks the email and the password
	$catpcha = strtoupper($_POST['captchastring']);
	
	if (empty($catpcha) || empty($_SESSION['CAPTCHAString']) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['am_error_log'][] = array('captcha_wrong');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

		$query = "
			SELECT user_id, status_id 
			FROM " . $db->prefix . "_user 
			WHERE 
			user_email=" . $db->qstr($_POST['email'], get_magic_quotes_gpc()) . " AND 
			status_id=" . $core_config['user']['status']['dormant'] . " AND
			user_dob=" . $db->qstr($dob, get_magic_quotes_gpc())
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$rec = array();
			$rec['status_id'] = $core_config['user']['status']['active'];
			
			$table = $db->prefix . "_user";
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
		else {
			$GLOBALS['am_error_log'][] = array('email_dob_mismatch'); // email - dob mismatch
		}
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: index.php?amn=core_login");
		exit;
	}
	
	$body->set('datedropdown', $date->dateDropdown());
	
	$body->set('display', 'dormant');
}

// we validate any referer request
if (!empty($_REQUEST['http_referer'])) {
	$amn_arr_new = explode("_", $_REQUEST['http_referer'], 2);
	$component_id_new = $amn_arr_new[0];
	
	$script_name_arr_new = explode(".", $amn_arr_new[1]);
	
	$script_name_new = $script_name_arr_new[0];
	
	$component_path_new = "components/" . $component_id_new . "/";
	
	if(!is_file($component_path_new . $script_name_new . ".php")) {
	    unset($_REQUEST['http_referer']);
	}
	else {
		$body->set('http_referer', $_REQUEST['http_referer']);
	}
}

?>