<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Quiz {
	// CLASS FUNCTIONS
	// Quiz
	// selQuiz
	// selQuestions
	// selOptions
	// selResult
	// insertQuiz
	// updateQuiz
	// insertQuestion
	// updateQuestion
	// deleteQuestion
	// insertOption
	// updateOption
	// deleteOption
	// insertResult
	// selQuizCount
	// selQuizzes
	// selQuestion
	// selResults



	// Quiz --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 14th April 2006
	//
	function Quiz($db, $rsp_item_type_id, $file = null) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		
		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Quiz




	// selQuiz --------------------------------------------------------------------
	// returns a single record from the DB
	// tom calthrop - 14th April 2006
	//
	function selQuiz($inc_questions=null, $inc_result=null) {

		$query = "
			SELECT quiz_id, quiz_title, quiz_body_intro, quiz_body_exit_pass, 
			quiz_body_exit_fail, quiz_pass_rate, group_id, quiz_synopsis, 
			quiz_start_datetime, quiz_end_datetime, user_id, 
			quiz_create_datetime, quiz_edit_datetime, quiz_retake_daycount, 
			quiz_display_answers, file_id, quiz_allow_comments  
			FROM " . $this->db->prefix . "_quiz 
			WHERE
			quiz_id=" . $this->quiz_id
		;
		
		//echo $query;
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {

			$temp = $result->fields;
			
			if (isset($inc_questions)) {
				$temp['questions'] = $this->selQuestions();
			}
			
			if (isset($inc_result)) {
				$temp['result'] = $this->selResult($temp['quiz_id']);
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selQuiz class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selQuiz



	// selQuestions --------------------------------------------------------------------
	// get the questions for the quiz
	// tom calthrop - 14th April 2006
	//
	function selQuestions() {

		$query = "
			SELECT question_id, quiz_id, question_body, 
			question_answer, 
			question_order, question_correct_option_id 
			FROM " . $this->db->prefix . "_quiz_question 
			WHERE
			quiz_id=" . $this->quiz_id . " AND "
		;
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by question_id";
		}
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 =  $result->fields;
				$temp1['options'] = $this->selOptions($temp1['question_id']);
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selQuestions class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selQuestions



	// selOptions --------------------------------------------------------------------
	// get the options for the quiz
	// tom calthrop - 14th April 2006
	//
	function selOptions($question_id) {
		$query = "
			SELECT option_id, option_body, question_id 
			FROM " . $this->db->prefix . "_quiz_option
			WHERE
			question_id=" . $question_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 =  $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selOptions class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selOptions



	// selResult ------------------------------------------------------------
	// get the result for the quiz
	// the quiz may be taken more than once so we can return many or just the 
	// latest result
	// tom calthrop - 14th April 2006
	//
	function selResult($quiz_id, $return_all=null) {
		$query = "
			SELECT result_id, user_id, quiz_id, result_create_datetime, 
			result_mark 
			FROM " . $this->db->prefix . "_quiz_result 
			WHERE 
			quiz_id=" . $quiz_id . " AND 
			user_id=" . $this->user_id
		;
		
		if (isset($return_all)) {
			$query .= " order by result_create_datetime desc";
			$result = $this->db->Execute($query);
		}
		else {
			$result = $this->db->SelectLimit($query, 1); //returns last 1 rows
		}
		if (isset($result->fields)) {
            if (isset($return_all)) {
				$temp = array();

				while (!$result->EOF) {
					$temp1 =  $result->fields;
					array_push($temp, $temp1);
					$result->MoveNext();
				}
			}
			else {
				$temp = $result->fields;
			}
			
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selResult class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selResult



	// insertQuiz --------------------------------------------------------------------
	// inserts the Quiz
	// tom calthrop - 14th April 2006
	//
	function insertQuiz($data) {

		if(empty($data['quiz_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['quiz_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(21, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['group_id'])) {
			    $data['group_id'] = "null";
			}
			
			if (empty($data['quiz_retake_daycount'])) {
			    $data['quiz_retake_daycount'] = "null";
			}
			
			if (empty($data['quiz_body_exit_pass'])) {
			    $data['quiz_body_exit_pass'] = "null";
			}
			
			if (empty($data['quiz_body_exit_fail'])) {
			    $data['quiz_body_exit_fail'] = "null";
			}
			
			if (empty($data['quiz_pass_rate'])) {
			    $data['quiz_pass_rate'] = "null";
			}
			
			if (empty($data['quiz_start_datetime'])) {
			    $data['quiz_start_datetime'] = "null";
			}
			
			if (empty($data['quiz_end_datetime'])) {
			    $data['quiz_end_datetime'] = "null";
			}
			
			if (empty($data['quiz_display_answers'])) {
			    $data['quiz_display_answers'] = "null";
			}
			
			if (empty($data['quiz_allow_comments'])) {
			    $data['quiz_allow_comments'] = "null";
			}
			
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}
			
			$rec = array();
			$rec['quiz_title'] = $data['quiz_title'];
			$rec['quiz_body_intro'] = $data['quiz_body_intro'];
			$rec['quiz_body_exit_pass'] = $data['quiz_body_exit_pass'];
			$rec['quiz_body_exit_fail'] = $data['quiz_body_exit_fail'];
			$rec['quiz_pass_rate'] = $data['quiz_pass_rate'];
			$rec['group_id'] = $data['group_id'];
			$rec['quiz_synopsis'] = $data['quiz_synopsis'];
			$rec['quiz_start_datetime'] = $data['quiz_start_datetime'];
			$rec['quiz_end_datetime'] = $data['quiz_end_datetime'];
			$rec['quiz_create_datetime'] = time();
			$rec['user_id'] = $this->user_id;
			$rec['quiz_retake_daycount'] = $data['quiz_retake_daycount'];
			$rec['quiz_display_answers'] = $data['quiz_display_answers'];
			$rec['quiz_allow_comments'] = $data['quiz_allow_comments'];
			$rec['file_id'] = $data['file_id'];
			
			$table = $this->db->prefix . "_quiz";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->quiz_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertQuiz class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertQuiz
	
	
	// updateQuiz --------------------------------------------------------------------
	// updates the Quiz
	// tom calthrop 14th April 2006
	//
	function updateQuiz($data) {

		if(empty($data['quiz_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['quiz_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(21, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['quiz_retake_daycount'])) {
			    $data['quiz_retake_daycount'] = "null";
			}
			
			if (empty($data['quiz_body_exit_pass'])) {
			    $data['quiz_body_exit_pass'] = "null";
			}
			
			if (empty($data['quiz_body_exit_fail'])) {
			    $data['quiz_body_exit_fail'] = "null";
			}
			
			if (empty($data['quiz_pass_rate'])) {
			    $data['quiz_pass_rate'] = "null";
			}
			
			if (empty($data['quiz_start_datetime'])) {
			    $data['quiz_start_datetime'] = "null";
			}
			
			if (empty($data['quiz_end_datetime'])) {
			    $data['quiz_end_datetime'] = "null";
			}
			
			if (empty($data['quiz_display_answers'])) {
			    $data['quiz_display_answers'] = "null";
			}
			
			if (empty($data['quiz_allow_comments'])) {
			    $data['quiz_allow_comments'] = "null";
			}
			
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_quiz 
				WHERE 
				quiz_id=" . $data['quiz_id']
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['quiz_title'] = $data['quiz_title'];
			$rec['quiz_body_intro'] = $data['quiz_body_intro'];
			$rec['quiz_body_exit_pass'] = $data['quiz_body_exit_pass'];
			$rec['quiz_body_exit_fail'] = $data['quiz_body_exit_fail'];
			$rec['quiz_pass_rate'] = $data['quiz_pass_rate'];
			$rec['quiz_synopsis'] = $data['quiz_synopsis'];
			$rec['quiz_start_datetime'] = $data['quiz_start_datetime'];
			$rec['quiz_end_datetime'] = $data['quiz_end_datetime'];
			$rec['quiz_edit_datetime'] = time();
			$rec['quiz_retake_daycount'] = $data['quiz_retake_daycount'];
			$rec['quiz_display_answers'] = $data['quiz_display_answers'];
			$rec['quiz_allow_comments'] = $data['quiz_allow_comments'];
			$rec['file_id'] = $data['file_id'];
			
			$table = $this->db->prefix . "_quiz";
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$this->quiz_id = $data['quiz_id'];
			
			if (empty($result)) {
				$error_info = "function=updateQuiz class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, $error_info);
			}
		}
	} //EO updateQuiz



	// insertQuestion --------------------------------------------------------------------
	// inserts the Quiz
	// tom calthrop - 14th April 2006
	//
	function insertQuestion($data) {

		if(empty($data['question_body'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['question_order'])) {
			    $data['question_order'] = "null";
			}
			
			if (empty($data['question_answer'])) {
			    $data['question_answer'] = "null";
			}
			
			$rec = array();
			$rec['quiz_id'] = $this->quiz_id;
			$rec['question_body'] = $data['question_body'];
			$rec['question_answer'] = $data['question_answer'];
			$rec['question_order'] = $data['question_order'];
			 
			$table = $this->db->prefix . "_quiz_question";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->question_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertQuestion class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertQuestion



	// updateQuestion --------------------------------------------------------------------
	// updates a question
	// tom calthrop - 14th April 2006
	//
	function updateQuestion($data) {

		if(empty($data['question_body'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['question_order'])) {
			    $data['question_order'] = "null";
			}
			
			if (empty($data['question_answer'])) {
			    $data['question_answer'] = "null";
			}
			
			if (empty($data['question_correct_option_id'])) {
			    $data['question_correct_option_id'] = "null";
			}
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_quiz_question 
				WHERE 
				question_id=" . $data['question_id']
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['question_body'] = $data['question_body'];
			$rec['question_answer'] = $data['question_answer'];
			$rec['question_order'] = $data['question_order'];
			$rec['question_correct_option_id'] = $data['question_correct_option_id'];
			 
			$table = $this->db->prefix . "_quiz_question";
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$this->question_id = $data['question_id'];
			
			if (empty($result)) {
				$error_info = "function=updateQuestion class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, $error_info);
			}
		}
	} //EO updateQuestion



	// deleteQuestion --------------------------------------------------------------------
	// deletes a  Quiz
	// tom calthrop - 14th April 2006
	//
	function deleteQuestion($question_id=null, $quiz_id=null) {
		
		if (isset($question_id) || isset($quiz_id)) {
			$query = "
				DELETE FROM " . $this->db->prefix . "_quiz_question 
				WHERE "
			;
					
			if (isset($question_id)) {
				 $query .= "question_id=" . $question_id;
			}
			elseif (isset($quiz_id)) {
				$query .= "quiz_id=" . $quiz_id;
			}
			
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=deleteQuestion class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteQuestion



	// insertOption --------------------------------------------------------------------
	// inserts the Quiz
	// tom calthrop - 14th April 2006
	//
	function insertOption($data) {

		if(empty($data['option_body'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			$rec = array();
			$rec['question_id'] = $this->question_id;
			$rec['option_body'] = $data['option_body'];
			
			$table = $this->db->prefix . "_quiz_option";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			$this->option_id = $this->db->Insert_ID();
			
			if (empty($result)) {
				$error_info = "function=insertOption class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertOption



	// updateOption --------------------------------------------------------------------
	// updates an option for a question
	// tom calthrop - 14th April 2006
	//
	function updateOption($data) {

		if(empty($data['option_body'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_quiz_option 
				WHERE 
				option_id=" . $data['option_id']
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['option_body'] = $data['option_body'];
			 
			$table = $this->db->prefix . "_quiz_option";
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (!empty($query) && empty($result)) { // if the query was empty then no update was required
				$error_info = "function=updateOption class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO updateOption



	// deleteOption --------------------------------------------------------------------
	// deletes a  Quiz
	// tom calthrop - 14th April 2006
	//
	function deleteOption($option_id=null, $question_id=null) {
		
		if (isset($question_id) || isset($option_id)) {
			$query = "
				DELETE FROM " . $this->db->prefix . "_quiz_option 
				WHERE "
			;
					
			if (isset($question_id)) {
				 $query .= "question_id=" . $question_id;
			}
			elseif (isset($option_id)) {
				$query .= "option_id=" . $option_id;
			}
			
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=deleteOption class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteOption



	// insertResult --------------------------------------------------------------------
	// inserts a result
	// tom calthrop - 14th April 2006
	//
	function insertResult($data) {

		$rec = array();
		$rec['user_id'] = $this->user_id;
		$rec['quiz_id'] = $this->quiz_id;
		$rec['result_mark'] = $data['result_mark'];
		$rec['result_create_datetime'] = time();
		
		$table = $this->db->prefix . "_quiz_result";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=insertResult class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO insertResult




	// selQuizzes --------------------------------------------------------------------
	// returns multiple records from the DB
	// tom calthrop - 14th April 2006
	//
	function selQuizzes($search = null) {

		$query = "
			SELECT q.quiz_id, q.quiz_title, q.quiz_body_intro, q.quiz_body_exit_pass, 
			q.quiz_body_exit_fail, q.quiz_pass_rate, q.group_id, q.quiz_synopsis, 
			q.quiz_start_datetime, q.quiz_end_datetime, q.user_id, 
			q.quiz_create_datetime, q.quiz_edit_datetime, q.quiz_retake_daycount, 
			q.quiz_display_answers, q.file_id "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", pr.profile_create_datetime, pr.profile_nic, pr.profile_hometown, rsp.rsp_sticky, rsp.rsp_featured ";
		}
			
		$query .= "FROM " . $this->db->prefix . "_quiz q ";
		
		if (isset($this->tag)) {
			$query .= ", " . $this->db->prefix . "_tag t  ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "	LEFT JOIN " . $this->db->prefix . "_user_profile pr ON q.user_id=pr.user_id AND pr.profile_default=1 ";
			$query .= ", " . $this->db->prefix . "_rsp rsp ";
		}
		
		$query .= "WHERE ";
		
		if (isset($this->tag)) {
			$query .= "
				q.quiz_id=t.item_id AND 
				t.user_id=" . $this->me['user_id'] . " AND 
				t.rsp_item_type_id=" . $this->item_types['quiz'] . " AND
				t.tag_body like " . $this->db->qstr("%" . $this->tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "
				rsp.item_id=q.quiz_id AND
				rsp.level_id=" . $this->rsp_level_id . " AND 
				rsp.rsp_item_type_id=" . $this->rsp_item_type_id . " AND "
			;
			
			if (isset($this->rsp_status_id)) {
				$query .= "rsp.status_id=" . $this->rsp_status_id . " AND ";
			}
			
			if (isset($this->degree_id)) {
				$query .= "rsp.degree_id>=" . $this->degree_id . " AND ";
			}
			else {
				$query .= "rsp.degree_id IS NULL AND ";
			}
			
			if (isset($this->rsp_featured)) {
				$query .= "rsp.rsp_featured=" . $this->rsp_featured . " AND ";
			}
		}
		
		if (isset($search)) {
			$query .= "
				(q.quiz_title like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR 
				q.quiz_synopsis like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . ") AND "
			;
		}
		
		if (isset($this->user_id)) {
		    $query .= "q.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
		    $query .= "q.group_id=" . $this->group_id . " AND ";
		}
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
					$user_ids .=",";
				}
			endforeach;
			$query .="q.user_id in (" . $user_ids . ") and ";
		}
		
		if (isset($this->quiz_ids)) { //used for bookmarks
			$quiz_ids = "";
			foreach($this->quiz_ids as $key => $i):
				$quiz_ids .= $i;
				if (count($this->quiz_ids) > $key+1) {
					$quiz_ids .=",";
				}
			endforeach;
			$query .= "q.quiz_id in (" . $quiz_ids . ") AND ";
		}
	
		if (isset($this->before_start_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->before_start_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "q.quiz_start_datetime <= " . $datetime . " AND ";
		}

		if (isset($this->after_start_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->after_start_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "q.quiz_start_datetime >= " . $datetime . " AND ";
		}
	
		if (isset($this->before_end_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->before_end_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "q.quiz_end_datetime <= " . $datetime . " AND ";
		}

		if (isset($this->after_end_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->after_end_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "q.quiz_end_datetime >= " . $datetime . " AND ";
		}
		
		$query .="1=1 ";

		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by q.quiz_title";
		}
		//echo $query;
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				$this->quiz_id = $temp1['quiz_id'];

				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
	 					$this->file->file_id = $temp1['file_id'];
	 					$temp1['image'] = $this->file->getFileRecord();
	 				}
	 				else {
	 					$temp1['image']['file_title'] = "";
	 					$temp1['image']['file'] = $this->file->noimage;
	 				}
				}
				
				if (isset($search)) { //format search results
					$temp1['quiz_title'] = searchTextFormat($search, $temp1['quiz_title']);
					$temp1['quiz_synopsis'] = searchTextFormat($search, $temp1['quiz_synopsis']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selQuizzes class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selQuizzes
	
	
	
	// selQuizCount --------------------------------------------------------------------
	// will get the count of a persons quizzes
	// tom calthrop - 14th April 2006
	//
	function selQuizCount($user_id = null) {
		$query = "
			SELECT quiz_id as total
			FROM " . $this->db->prefix . "_quiz 
			WHERE "
		;
		
		if (isset($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
		    $query .= "group_id=" . $this->group_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=selQuizCount class=Poll.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO selQuizCount



	// selQuestion --------------------------------------------------------------------
	// get the question for the quiz
	// tom calthrop - 14th April 2006
	//
	function selQuestion($question_id) {
		
		$query = "
			SELECT question_id, quiz_id, question_body, 
			question_answer, 
			question_order, question_correct_option_id 
			FROM " . $this->db->prefix . "_quiz_question 
			WHERE
			question_id=" . $question_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = $result->fields;
			$temp['options'] = $this->selOptions($temp['question_id']);

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selQuestion class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selQuestion



	// selResults ------------------------------------------------------------
	// get the results for a users quiz participation
	// tom calthrop - 17th May 2006
	//
	function selResults() {
		$query = "
			SELECT DISTINCT quiz_id 
			FROM " . $this->db->prefix . "_quiz_result 
			WHERE 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
           $temp = array();

			while (!$result->EOF) {
				$temp1 =  $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selResults class=Quiz.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selResults
}

?>
