<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";

if (isset($_REQUEST['group_id'])) {
	include_once ('inc/header_group.inc.php');
	require_once($languagePath . 'grp_common.lang.php');
	
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['administration'], $c_acs['arr_acs']['privilege']['allow_newsletter'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	
	$output_group['roles'] = $group_acs->getGroupRoles();
}
else {
	if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['administration'], $c_acs['arr_acs']['privilege']['allow_newsletter'])) { //resourece_id, Priv_id
		header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
		exit;
	}
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'nlt_view.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_acs.lang.php');


// SETUP NEWSLETTER -----------------------------------------------------
if (isset($_POST['send_newsletter'])) {

	require_once('class/Newsletter.class.php');
	$nl = new Newsletter($db, $c_node['newsletter']);
	
	$nl->insertNewsletter($frmdata);
	if (empty($GLOBALS['am_error_log'])) {
		//send newsletter
		if($c_node['batch']['enabled'] != true) {
			//we send email directly 
			unset($_SESSION['newsletter_id']);
			$_SESSION["newsletter_id"] = $nl->message_id;
			header("Location: nlt_send.php");
			exit;
		}
		else {
			if (!empty($_REQUEST['group_id'])) {
				$url = "nlt_edit.php?group_id=" . $_REQUEST['group_id'] . "&croncomplete=1";
			}
			else {
				$url = "nlt_edit.php?croncomplete=1";
			}
			
			header("Location: " . $url);
			exit;
		}
	}
}
elseif (isset($_REQUEST['complete'])) {
	if ($_REQUEST['complete'] < 1) {
		$_REQUEST['complete'] = 0;
	}
}


//move to template
if (isset($_REQUEST['complete'])) {
	$body->set('total_emails_sent', $_REQUEST['complete']);
}

if (isset($_REQUEST['croncomplete'])) {
	$body->set('croncomplete', $_REQUEST['croncomplete']);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	
	$body->set('total_members', $group->getCountMembers());
}
else {
	$body->set('language_id', $me['language_id']);
	$body->set('total_members', getCountUsers($c_node['user']['status']['active']));
	$body->set('total_pending_members', getCountUsers($c_node['user']['status']['pending']));
	$body->set('total_invited', getCountInvitedUsers());
}

$body->set('newsletter_type_ids', $c_node['newsletter']['type']);



function getCountUsers($status_id = null) {
	
	global $db;
	$total = 0;
	
	$query = "
		SELECT count(user_id) as total  
		FROM " . $db->prefix . "_user 
		WHERE "
	;
	
	if (isset($status_id)) {
		$query .= "status_id=". $status_id . " AND ";
	}
	
	$query .= "1=1";
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$total = $result->fields['total'];
	}
	
	return $total;
}

function getCountInvitedUsers() {
	
	global $db;
	$total = 0;
	
	$query = "
		SELECT count(invited_email) as total 
		FROM " . $db->prefix . "_user_invited"
	;
	
	$result = $db->Execute($query);
	
	if (!empty($result)) {
		$total = $result->fields['total'];
	}
	
	return $total;
}

include "inc/footer.inc.php";

?>
