<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "my";
include "inc/header.inc.php";


if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'my_common.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_homepage.lang.php');
require_once($languageArrayPath . 'arr_rsp.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


if (isset($_REQUEST['edit_membership'])) {
	$user->user_id = $me['user_id'];
	$output_user = $user->getUser();
	
	$output_user['language_ids'] = $user->getLanguages();

	$display = "edit_membership";

}
elseif (isset($_REQUEST['update_membership'])) {
	$user->user_id = $me['user_id'];
	$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];
	$frmdata['user_dob'] = $dob;

	//update profile
	$user->updateUser($frmdata);

	if (empty($GLOBALS['am_error_log'])) {
		//update the user languages
		$user->deleteLanguages();
		$user->insertLanguages($frmdata['language_ids']);
		$_SESSION['language_ids'] = $frmdata['language_ids'];
		$_SESSION['language_id'] = $frmdata['language_id'];
		
		if (isset($_SESSION['template_id']) && $_SESSION['template_id'] != $frmdata['template_id']) {
			$output_template = $user->getTemplate($frmdata['template_id']);
			$_SESSION['template_id'] = $output_template['template_title'];
		}
		
		header("Location: my_membership.php?" . strip_tags(SID));
		exit;
	}
	else {
		$output_user = $frmdata;
		$display = "edit_membership";
	}


}
elseif (isset($_POST['update_email'])) {
	$output_user = $user->getUser($me['user_id']);
	
	//update email
	if(isset($output_user['user_email']) && isset($frmdata['user_email1']) && ($frmdata['user_email1'] != $output_user['user_email'])) {
		if(empty($frmdata['user_email1']) || empty($frmdata['user_email2'])) {
			$GLOBALS['am_error_log'][] = array(2, null, null);
		}

		if($frmdata['user_email1'] != $frmdata['user_email2']) {
			$GLOBALS['am_error_log'][] = array(14, null, null);
		}

		if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $frmdata['user_email1'])) {
			$GLOBALS['am_error_log'][] = array(3, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			//check that the email is not already used
			$query = "
				SELECT user_id
				FROM " . $db->prefix . "_user
				WHERE user_email='" . $frmdata['user_email1'] . "'"
			;

			$result = $db->Execute($query);

			if (isset($result) && empty($result->fields)) {
				//we now reset the password and send an email with the new login details
				$query = "
					UPDATE " . $db->prefix . "_user SET
					user_email=" . $db->qstr($frmdata['user_email1'], get_magic_quotes_gpc()) . ", 
					status_id=" . $c_node['user']['status']['dormant'] . "
					WHERE
					user_id=" . $me['user_id']
				;

				$db->Execute($query);

				$user->logoffUser();
				header("Location: spl_view.php?dormant=1");
				exit;
			}
		}
		else {
			$output_user['language_ids'] = $user->getLanguages();

			$display = "edit_membership";
		}
	}
}
else {
	$user->user_id = $me['user_id'];
	$output_user = $user->getUser();
	
	//setup statistics
	require_once('class/Statistic.class.php');
	$statistic = new Statistic($db, null);
	$statistic->user_id = $me['user_id'];
	$output_statistic = $statistic->getStatistics();

	$output_user['template'] = $user->getTemplate($output_user['template_id']);
	$output_user['language_ids'] = $user->getLanguages();


	//create RSS URL
	$url = "http://" . $_SERVER['HTTP_HOST'];
	$url .= dirname ($_SERVER['PHP_SELF']);
	//sometimes the server adds / as the last characture - we need to check.
	if (substr($url, -1, 1) != "/") {
	    $url .= "/";
	}
	
	$rss_public_url = $url . "rss_feed.php";
	
	if (isset($me['user_id']) && $me['user_id'] > 0) {
		$rss_url = $url . "rss_feed.php?feed=" . $me['user_feed_password'] . $me['user_id'];
	}

	$rss_url = $url . "rss_feed.php?feed=" . $output_user['user_feed_password'] . $output_user['user_id'];


	$display = "view_membership";
}

if (isset($_REQUEST['update_user_preferences'])) {
	$user->deletetUserPreference(null, $me['user_id']);
	
	if (isset($frmdata['user_preferences'])) {
		foreach ($frmdata['user_preferences'] as $key => $i):
			$user->insertUserPreference($key, $me['user_id'], $i);
		endforeach;
	}
}

//ACS check - we may not be allowed to set the network page as our homepage
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['network'], $c_acs['arr_acs']['privilege']['allow_network'])) { //resourece_id, Priv_id
	unset($lang['homepage']['page'][6]);
}


$output_user['preferences'] = $user->selUserPreferences();

// if no cron remove cron based preferences
if (!isset($c_node['batch']['enabled']) || $c_node['batch']['enabled'] != true) {
	unset($lang['user']['preference'][$c_node['user']['preference']['digest_newsletter']]);
}


$output_template = $user->getTemplates();


//move to template
if (!empty($rss_public_url)) {
	$body->set('rss_public_url', $rss_public_url);
}

if (!empty($output_user)) {
   $body->set('user', $output_user);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_template)) {
   $body->set('templates', $output_template);
}

if (!empty($output_statistic)) {
	$body->set('user_statistic', $output_statistic);
}

if (!empty($rss_url)) {
	$body->set('rss_url', $rss_url);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);
$body->set('user_preference_ids', $c_node['user']['preference']);
$body->set('datedropdown', $date->dateDropdown($output_user['user_dob']));
$body->set('batch_enabled', $c_node['batch']['enabled']);

include "inc/footer.inc.php";

?>
