<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'grp_common.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_rsp.lang.php');


//setup Wiki
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');

$output_group['group_home_synopsis'] = $wiki->transform($output_group['group_home_synopsis'], 'Xhtml');


$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];

//get group image
if (!empty($output_group['file_id'])) {
	$file->file_id = $output_group['file_id'];
	$output_group['image'] = $file->getFileRecord();
}
else {
	$output_group['image']['file_title'] = "";
	$output_group['image']['file'] = $file->noimage;
}


$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup statistics
require_once('class/Statistic.class.php');
$statistic = new Statistic($db, null, $date);
$statistic->group_id = $group_id;
$output_statistic = $statistic->getStatistics();


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, null);
$comment->wiki = $wiki;


//get subjects  -----------------------------------------------------
require_once('class/Forum.class.php');
$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $file);
$forum->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$forum->rsp_status_id = $c_node['rsp']['status']['live'];
$forum->group_id = $group_id;
$forum->limit = 10;
$output_subjects = $forum->selSubjects();

if (!empty($output_subjects)) {
	$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
	
	foreach($output_subjects as $key => $i):
		$output_subjects[$key]['comment_total'] = $comment->getCommentCount($i['subject_id']);
	endforeach;
}

//get blogs -----------------------------------------------------
require_once('class/Blog.class.php');
$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $file);
$blog->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$blog->rsp_status_id = $c_node['rsp']['status']['live'];
$blog->group_id = $group_id;
$blog->limit = 10;
$output_blogs = $blog->selBlogs();

if (!empty($output_blogs)) {
	$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	
	foreach($output_blogs as $key => $i):
		$output_blogs[$key]['comment_total'] = $comment->getCommentCount($i['blog_id']);
	endforeach;
}


//get group poll ids -----------------------------------------------------
require_once('class/Poll.class.php');
$poll = new Poll($db, $c_node['rsp']['item_type']['poll']);
$poll->order_by = "poll_start_datetime desc";
$poll->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$poll->rsp_status_id = $c_node['rsp']['status']['live'];
$poll->group_id = $group_id;
$poll->limit = 10;
$output_polls = $poll->selPolls();


//get library items -----------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, $c_node['rsp']['item_type']['library'], $file);
$library->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$library->rsp_status_id = $c_node['rsp']['status']['live'];
$library->group_id = $group_id;
$library->limit = 10;
$output_library = $library->selLibraryItems();


//schedule setup -----------------------------------------------------------
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
$schedule->group_id = $group_id;
$schedule->schedule_config = $c_node['schedule'];
$schedule->limit = 10;
$output_schedule_items = $schedule->selScheduleItems();


// get comments ------------------------------------------------------------
$comment->group_id = $group_id;
$comment->limit = 10;
$comment->orderby = "c.comment_create_datetime desc";
unset($comment->rsp_item_type_id);
$output_comments = $comment->selComments();

// get my tags
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['group']);
$tag->item_id = $group_id;

if (isset($_POST['update_tag'])) {
	$tag->user_id = $me['user_id'];
	$frmdata['item_id'] = $group_id;
	//unset($frmdata['group_id']);
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: grp_view.php?group_id=". $group_id . "&" . strip_tags(SID));
	exit;
}
	
if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
	$output_my_tags = $tag->selTags();
	$output_network_tags = $tag->selTags('network');
	
}

unset($tag->user_id);
$output_group_tags = $tag->selTags();

//get the user details for the rss feed link
if (isset($me['user_id'])) {
	$user->user_id = $me['user_id'];
	$output_user = $user->getUser();
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
	$lang['nav_breadcrumb_note'] = $output_group['group_title'];
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_schedule_items)) {
	$body->set('schedule_items', $output_schedule_items);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_group_tags)) {
	$body->set('item_tags', $output_group_tags);
}

if (!empty($output_network_tags)) {
	$body->set('network_tags', $output_network_tags);
}

if (!empty($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);

include "inc/footer.inc.php";

?>
