<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// we select people
// foreach person we calculate their social network
// for each degree we update the social network statistics
// we remove the calculate social network flag from their _sn table entry

$path = dirname(__FILE__) . "/";

include $path . "../config/config_aroundme.inc.php";
include $path . "../inc/functions.inc.php";

// SETUP DATABASE -----------------------------------------------------------------------
require_once($path . '../class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
if ($db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db'])) {
	$db->prefix = $c_node['db']['prefix'];
	
	//setup social network
	require_once($path . '../class/SocialNetwork.class.php');
	$sn = new Socialnetwork(null, $db);
	$sn->relation_type_ids = $c_node['user']['relation_type'];
	$sn->status_ids = $c_node['user']['status'];
	$sn->max_degree = $c_node['sn']['max_degree'];
	
	//select users
	$query = "
		SELECT user_id 
		FROM " . $db->prefix . "_sn 
		WHERE
		sn_batch_request=1 AND 
		degree_id=1"
	;
	
	$users_result = $db->Execute($query);
	
	if (isset($users_result->fields)) {
		while (!$users_result->EOF) {
			$user_id = $users_result->fields['user_id'];
			
			//we compute their social network statistics
			$sn->user_id = $user_id;
			$sn->createNetwork();
			
			//update the statistics
			$sn->updateSnStatistics();
			//reset the flag from their _sn table entry
			$query = "
				SELECT user_id, sn_batch_request 
				FROM " . $db->prefix . "_sn 
				WHERE
				user_id=" . $user_id
			;
			
			$result = $db->Execute($query);
			
			$rec = array();
			$rec['sn_batch_request'] = "null";
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			$users_result->MoveNext();
		}
	}
}

?>