<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<?php
	if (isset($library)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($library['library_create_datetime'], 1);?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<div class="metadata_top">
					<b><?php echo $lang['txt_item_options'];?></b> -&#62; 
					<?php
					if (isset($group)) {
					if ($this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
						$allow_edit = 1;
					}
					}
					elseif ($this->user_acs->checkPermission($resource_ids['node']['library'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
						$allow_edit = 1;
					}
					
					if (!empty($allow_edit)) {
					?>
					<a href="lib_edit.php?library_id=<?php echo $library['library_id'];?>"><?php echo $lang['href_edit'];?></a>
					,&nbsp;
					<?php }?>
					
					
					<?php
					if (isset($me['user_id']) && $me['user_id'] > 0) { // we need to be logged in
					?>
					
					<?php
					if (isset($library['bookmark']['watch'])) {
					?>
					<a href="lib_view.php?library_id=<?php echo $library['library_id'];?>&amp;bookmark=del_mark"><?php echo $lang['href_unwatch_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="lib_view.php?library_id=<?php echo $library['library_id'];?>&amp;bookmark=ins_mark"><?php echo $lang['href_watch_this'];?></a>
					<?php }?>
					,&nbsp;
					
					<?php
					if (isset($library['bookmark']['recommend'])) {
					?>
					<a href="lib_view.php?library_id=<?php echo $library['library_id'];?>&amp;bookmark=del_tip"><?php echo $lang['href_unrecommend_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="lib_view.php?library_id=<?php echo $library['library_id'];?>&amp;bookmark=ins_tip"><?php echo $lang['href_recommend_this'];?></a>
					<?php }?>
					
					<?php
					if (!isset($library['bookmark']['watch']) && $batch_enabled == true) {
					?>
					,&nbsp;
					<a href="lib_view.php?library_id=<?php echo $library['library_id'];?>&amp;bookmark=ins_mark&amp;notify=1"><?php echo $lang['href_watch_this_notify'];?></a>
					<?php }?>
					<?php }?>
					<br />
				</div>
				
				<p class="txt_item_title">
					<?php echo $library['library_title'];?><br />
				</p>
				
				<p>
					<?php echo $library['library_body_display'];?><br />
				</p>
				
				<div class="metadata">
					<?php
					if (isset($author)) {
						if (isset($group)) {
							$profile_url = "grp_membership.php?group_id=" . $group['group_id'] . "&amp;user_id=" . $author['user_id'];
						}
						else {
							$profile_url = "sn_profile.php?user_id=" . $author['user_id'];
						}
					?>
					<p>
						<b><?php echo $lang['txt_author'];?></b> -&#62; 
						<?php echo $lang['txt_profile_nic'];?>: 
						<a href="<?php echo $profile_url;?>"><?php echo $author['profile_nic'];?></a>, 
						<?php echo $lang['txt_profile_session_status'];?>: 
						<?php
						if ($author['online_status'] == 1) {
							echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
						}
						else {
								echo $lang['arr_user_online_status'][$author['online_status']];
						}
						?>, 
						<?php echo $lang['txt_hometown'];?>: 
						<?php echo $author['profile_hometown'];?>, 
						<?php echo $lang['txt_joined'];?>: 
						<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
						<?php
						if (isset($group)) {
						?>
						&nbsp;<?php echo $lang['txt_group_link'];?>: <a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $group['group_title'];?></a>
						<?php }?>
						<br />
					</p>
					<?php }?>
					
					<p>
						<b><?php echo $lang['hdr_library_item'];?></b> -&#62; 
						
						<?php echo $lang['txt_page_name'];?>:
						<?php echo $library['library_page_name'];?>, 
							
						<?php
						if (isset($newest)) {
							if (isset($group)) {
								$url = "lib_view.php?view=history&amp;group_id=" . $group['group_id'] . "&amp;library_id=" . $library['library_id'];
							}
							else {
								$url = "lib_view.php?view=history&amp;library_id=" . $library['library_id'];
							}
						?>
						(<?php echo $lang['txt_version_lastest'];?>&nbsp;<a href="<?php echo $url;?>"><?php echo $lang['href_doc_history'];?></a> )
						<?php
						}
						else {
						?>
						(<?php echo $lang['txt_version_old'];?>&nbsp;<a href="lib_view.php?page=<?php echo $library['library_page_name'];?>"><span class="txt_error"><b><?php echo $lang['href_view_latest'];?></b></span></a> )
						
						<?php }?>, 
									
						<?php
						if (!empty($blog['bookmark'])) {
							echo $lang['txt_bookmarks'] . ": ";
							
							if (!empty($blog['bookmark']['watch'])) {
								echo $lang['txt_marked'];
							}
							
							if (!empty($blog['bookmark']['recommend'])) {
								echo $lang['txt_tipped'];
							}
							echo ", ";
						}
						?>
						
						<?php echo $lang['txt_published_to'];?>: 
						<?php
						if (isset($library['rsp'])) {
							foreach($library['rsp'] as $key => $i):
								
								echo trim($lang['rsp']['rsp_level'][$i['level_id']] . " " . $i['degree_id']);
								echo " (" .$lang['rsp']['status'][$i['status_id']] . ")";
								if ($key+1 < count($library['rsp'])) {
									echo ", ";
								}
								
							endforeach;
						}
						?>
						<br />
					</p>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (!empty($library['library_allow_comments'])) {
					$unlocked = 1;
				}
				
				$hidden_form = array(
					"library_id" => $library['library_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				
				if (isset($group['group_id'])) {
					$hidden_form['group_id'] = $group['group_id'];
				}
				
				if (isset($blog['user_id'])) {
					$hidden_form['item_user_id'] = $library['user_id'];
				}
				
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($library_items)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_library'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
				?>
				<p>
					<?php echo $lang['txt_intro'];?><br />
				</p>
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?
					foreach($library_items as $key => $i):
					?>
					<tr>
						<td valign="top" nowrap="nowrap">
							<?php
							if (isset($profile)) {
							?>
							<a href="lib_view.php?user_id=<?php echo $i['user_id'];?>&amp;library_id=<?php echo $i['library_id'];?>"><?php echo $i['library_create_datetime'];?></a><br />
							<?php
							}
							else {
							?>
							<a href="lib_view.php?library_id=<?php echo $i['library_id'];?>"><?php echo $this->date->formatDate($i['library_create_datetime']);?></a><br />
							<?php }?>
						</td>
						<td valign="top">
							<?php echo $i['library_title'];?><br />
						</td>
						<td valign="top" width="1%">
							<?php echo $i['library_page_name'];?><br />
						</td>
						<td valign="top" width="1%">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	else {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_library'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_items'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>


<div class="col_side">
	<?php
	if (isset($group)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
				</p>
				
				<?php
				if (isset($group['image']['file_id'])) {
				?>
				<img src="get_file.php?file=<?php echo $group['image']['file'];?>" border="0" alt="<?php echo $group['image']['file_title'];?>" /><br />
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_membership_status'];?><br />
						</td>
						<td>
							<?php echo $group['member']['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_language'];?><br />
						</td>
						<td>
							<?php
							if (isset($lang['arr_lang_name'][$group['language_id']])) {
								echo $lang['arr_lang_name'][$group['language_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_type'];?><br />
						</td>
						<td>
							<?php 
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden'];
							}
							
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_rec_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $lang['txt_age_from'] . " " . $group['group_from_age'];
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo $lang['txt_age_upto'] . " " . $group['group_to_age'];
							}
							else {
								echo $lang['txt_age_all'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
				
				<?php
				if (!empty($group['member']['role_visitor'])) {
				?>
				<p align="right">
					<b><a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_join'];?></a></b><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $lang['txt_view'];?></b><br />
				</p>
				
				<?php
				if (isset($view) && $view == "firstpage") {
				?>
				<?php echo $lang['href_view_firstpage'];?><br />
				<?php
				}
				else {
					if (isset($group)) {
						$url = "lib_view.php?view=firstpage&amp;group_id=" . $group['group_id'];
					}
					else {
						$url = "lib_view.php?view=firstpage";
					}
				?>
				<a href="<?php echo $url;?>"><?php echo $lang['href_view_firstpage'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "contents") {
				?>
				<?php echo $lang['href_view_contents'];?><br />
				<?php
				}
				else {
				if (isset($group)) {
				?>
				<a href="lib_view.php?group_id=<?php echo $group['group_id'];?>&amp;view=contents"><?php echo $lang['href_view_contents'];?></a><br />
				<?php
				}
				else {
				?>
				<a href="lib_view.php?view=contents"><?php echo $lang['href_view_contents'];?></a><br />
				<?php }}?>
				
				<?php
				if (isset($me['user_id'])) {
				?>
				
				<?php
				if (isset($view) && $view == "my_library") {
				?>
				<?php echo $lang['href_my_library'];?><br />
				<?php
				}
				else {
				?>
				<a href="lib_view.php?view=my_library"><?php echo $lang['href_my_library'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "marked_library_items") {
				?>
				<?php echo $lang['href_marked'];?><br />
				<?php
				}
				else {
				?>
				<a href="lib_view.php?view=marked_library_items"><?php echo $lang['href_marked'];?></a><br />
				<?php }?>
				<?php }?>
				
				<p>
					<b><?php echo $lang['txt_options'];?></b><br />
				</p>
				
				<?php
				if (isset($group)) {
				if ($this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
				?>
				<a href="lib_edit.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_add_group_library'];?></a><br />
				<?php
				}
				}
				elseif ($this->user_acs->checkPermission($resource_ids['node']['library'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
				?>
				<a href="lib_edit.php"><?php echo $lang['href_add_library'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($library)) {
				?>
					<p>
						<b><?php echo $lang['hdr_tag'];?></b><br />
					</p>
					
					<p>
						<?php
						$tags = "";
						if (isset($item_tags)) {
							foreach ($item_tags as $key => $i):
								$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
								
								if ($i['user_id'] == $me['user_id']) {
									$tags .= "*";
								}
								
								if (count($item_tags) > $key+1) {
									$tags .= ", ";
								}
							endforeach;
							echo $tags;
						}
						?>
					</p>
					
					<?php
					if ($this->user_acs->checkPermission($resource_ids['node']['library'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= $i['tag_body'];
							if (count($my_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
					}
					?>
					
					
					<form action="lib_view.php" method="post" name="frm_view" id="id_frm_view">
					<input type="hidden" name="library_id" value="<?php if(isset($library['library_id'])) { echo $library['library_id'];}?>" />
					<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
					
					<p>
						<input width="30" class="input" name="tags" value="<?php echo $tags;?>" />
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
					</p>
					</form>
					<?php }?>
				<?php }?>
				
				<p>
					<b><?php echo $lang['hdr_search'];?></b><br />
				</p>
				
				<form action="search.php" method="post" name="search" id="id_search">
				<input type="hidden" name="search_type" value="library" />
				
				<p>
					<input type="text" class="input" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
				
				</form>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	if (isset($sidebar_items)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_history'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				foreach($sidebar_items as $key => $i):
				?>
				<p>
					<a href="lib_view.php?library_id=<?php echo $i['library_id'];?>"><?php echo $this->date->formatDate($i['library_create_datetime'], 1);?></a><br />
					<?php echo $i['library_title'];?><br />
					<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
					<br />
				</p>
				<?php
				endforeach;
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>