<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";


//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['administration'], $c_acs['arr_acs']['privilege']['allow_acs'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


require_once('class/Acs.class.php');
$acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['node']);

//append language setup
require_once($languageArrayPath . 'arr_acs.lang.php');


//ROLES
$output_roles = array();

//loop through the array and get the name from the language file
foreach($lang['arr_acs']['role'] as $key => $i):
	$temp1['role_name'] = $i;
	$temp1['role_id'] = $key;
	array_push($output_roles, $temp1);
endforeach;



//RESOURCES
//get resource_id's from config and build the resources array
$config_resources = $c_acs['arr_acs']['resource']['node'];
$resource_privilege = $c_acs['resource_privilege'];
$arr_acs = $lang['arr_acs'];

$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);

	
if(isset($_POST['update_permissions'])){

	$acs->deletePermissions();                          // Resets all the permissions
	
	
	if(!empty($frmdata['ids'])){
		foreach($frmdata['ids'] as $key => $value){
			$ind = explode("-", $key);
			
			$resource_id  = $ind[0];		// resource_id
			$privilege_id = $ind[1];		// privilege_id
			$role_id      =  $output_roles[$ind[2]]["role_id"];		// role_id
			$acs->insertPermission($role_id, $resource_id, $privilege_id);  // insert privileges
		}
	}

	$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);
}
	


//move to template
if (!empty($output_roles)) {
    $body->set('roles', $output_roles);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (!empty($output_resources)) {
    $body->set('resources', $output_resources);
}

include "inc/footer.inc.php";

?>
