<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_blg.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_blog'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
}


//wiki
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['blog'], $date);
$comment->user_id = $me['user_id'];
$comment->wiki = $wiki;
if (isset($group_id)) {
    $comment->group_id = $group_id;
}


// SETUP TAGS
require_once($c_node['dir']['class_path'] . 'Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['blog']);
$tag->user_id = $me['user_id'];
if (isset($group_id)) {
    $tag->group_id = $group_id;
}

if (isset($_POST['update_tag'])) {
	$tag->deleteTags($frmdata);
	$tag->insertTags($frmdata);
}
elseif (isset($_POST['preview'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');

	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $blog->blog_id;
	$comment->insertComment($frmdata);
	
	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $date);
		//update stats
		if (!empty($group_id)) { // page under group section
			//group member comments
			$comment->group_id = $group_id;
			unset($comment->rsp_item_type_id, $comment->item_id);
			$comment->user_id = $me['user_id'];
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
			//group stats
			unset($comment->user_id, $statistic->user_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
		}

		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());

		if (!empty($group_id)) { // page under group section
			return header("Location: blg_item.php?group_id=". $group_id . "&blog_id=". $blog->blog_id . "&" . SID);
		}
		else {
			return header("Location: blg_item.php?blog_id=". $blog->blog_id . "&user_id=" . $user_id . "&" . SID);
		}
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}



//get $blog
unset($blog->file);
$output_blog = $blog->getBlog();

if (!empty($output_blog)) {
	//wikify body
	if (!empty($output_blog['group_id'])) { // page under group section
	    $wiki_path = "lib_item.php?group_id=" . $output_blog['group_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?group_id=" . $output_blog['group_id'] . "&page=";
		$wiki_image_base = "get_file.php?file=group/";

	}
	else {
	    $wiki_path = "lib_item.php?user_id=" . $output_blog['user_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?page=";
		$wiki_image_base = "get_file.php?file=user/";
	}
	require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
	$wiki =& new Text_Wiki();
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');


	//get the group and/or the author
	$user->user_id = $output_blog['user_id'];
		
	if (!empty($output_group['group_id'])) {
		$user->group_id = $output_group['group_id'];
		$output_author = $user->getProfile();
	}
	elseif (!empty($output_blog['group_id']) && $menu_section != "my") {
		require_once($c_node['dir']['class_path'] . 'Group.class.php');
		$group = new Group($db, $date, $file);
		$group->group_id = $output_blog['group_id'];
		$output_group = $group->getGroup();
		$user->group_id = $output_group['group_id'];
		$output_author = $user->getProfile();
	}
	else {
		$output_author = $user->getProfile();
	}


	//setup bookmarks --------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['blog'], $date, $me['user_id']);
	$bookmark->item_id = $blog->blog_id;

	//watching
	$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
	//set or unset bookmarks
	if (isset($_REQUEST['watch'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unwatch'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$tpl->set('toolbar_watch', 1);
	}

	//recommended
	$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
	//set or unset bookmarks
	if (isset($_REQUEST['recommend'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unrecommend'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$tpl->set('toolbar_recommend', 1);
	}


	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($blog->blog_id);

	//get RSP items if I am looking at my blog
	if ($output_blog['user_id'] == $me['user_id']) {
		require_once($languageArrayPath . 'arr_rsp.lang.php');
		require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
		$rsp = new Rsp($db, $c_node['rsp']['item_type']['blog']);
		$output_blog['rsp'] = $rsp->selRspItem($blog->blog_id);

		$body->set('rsp_config', $c_node['rsp']);
	}
	
	
	//get tags
	unset($tag->group_id);
	$tag->item_id = $blog->blog_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_network_tags = $tag->selTags('network');
	
	if (isset($group_id)) {
		$tag->group_id = $group_id;
		$output_group_tags = $tag->selTags();
	}

}



//we list 10 others
$blog->limit = 10;
if (!empty($group_id)) { // page under group section
	unset($blog->user_id);
	$output_blogs = $blog->selBlogs();
}
elseif ($menu_section == "my") {
    $output_blogs = $blog->selBlogs();
}
else {
	$output_blogs = $blog->selBlogs();
}

if (!empty($output_blogs)) {
	foreach($output_blogs as $key => $i):
		unset($comment->user_id, $comment->section_id, $comment->section_item_id, $comment->rsp_item_type_id);
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$output_blogs[$key]['comment_total'] = $comment->getCommentCount($i['blog_id']);
	endforeach;
}



//move vars to template
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_statistic)) {
	$body->set('profile_statistic', $output_statistic);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_group_tags)) {
	$body->set('group_tags', $output_group_tags);
}

if (!empty($output_network_tags)) {
	$body->set('network_tags', $output_network_tags);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}


//setup print options
$tpl->set('toolbar_print', 'print_item.php?blog_id=' . $output_blog['blog_id']);
$tpl->set('toolbar_printc', 'print_item.php?blog_id=' . $output_blog['blog_id'] . '&amp;inc_comment=1');

if (isset($_REQUEST['group_id'])) {
	$tpl->set('toolbar_bookmark_url', 'blg_item.php?group_id=' . $_REQUEST['group_id'].'&amp;blog_id=' . $output_blog['blog_id']);
}
else {
	$tpl->set('toolbar_bookmark_url', 'blg_item.php?blog_id=' . $output_blog['blog_id']);
}

if (isset($output_blog['blog_title'])) {
    $template_pageLink = $lang['txt_blog'];
	$template_pageLinkNote = $output_blog['blog_title'];
}

include "inc/footer.inc.php";

?>