<?php
// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

session_start();
include "config/config_aroundme.inc.php";

// SETUP ERROR HANDLING -----------------------------------------------------------------------
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['am_error_log'] = array();


// SETUP DATABASE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//SETUP DATE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Date.class.php');
$date = new Date();


// setup email
require_once($c_node['dir']['class_path'] . '/Batch.class.php');
require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');

// set up the mailer
$mail = new PHPMailer();
$mail->Host = 				$c_node['mail']['host'];
$mail->Mailer = 			$c_node['mail']['mailer'];
$mail->From = 				$c_node['mail']['default_address'];
$mail->FromName = 			$c_node['mail']['from_name'];
$mail->WordWrap = 			$c_node['mail']['wordwrap'];
$mail->language = 			"en";
$mail->Priority = 			3;
$mail->Encoding = 			"8bit";
$mail->CharSet = 			"iso-8859-1";
$mail->SMTPKeepAlive =      true;
$mail->IsHTML(true);

 // set up the Batch-email class
$batch = new Batch($db, $c_node['newsletter']['nr_per_batch']);

// get an unsent newsletter
if(empty($c_node["cron"]["bulk_mail"])){
	$query  = "SELECT * FROM ".$db->prefix."_newsletter WHERE message_id=".$_SESSION["s_newsletter_id"]." AND message_status=0";          
	$result = $db->SelectLimit($query, 1, 0);                // get the email from the table with unsent newsletters
}
else{
	$query  = "SELECT * FROM ".$db->prefix."_newsletter WHERE message_status=0";          
	$result = $db->SelectLimit($query, 1, 0);                // get the email from the table with unsent newsletters
}
 
// if unsent newsletters exists, send one "batch" of them.
if(isset($result->fields)){ 

	// add on more options for the group, events and so forth
	if($result->fields["item_type"] == $c_node['newsletter']['type']['node'])
		$referrer = "node_newsletter.php";   

	// Sets the sender's different characteristics...
	$to_type_id     = $result->fields["to_type_id"];  // Change to other format?
	
	$text = "";                      // Text-version of the mail.
	$body = $result->fields["message_body"]; // HTML-version of the email
	 
	// if file attachments ever happens :)
	if(isset($result->fields["file"]) & !empty($result->fields["file"])){
		$mail->AddAttachment($result->fields["file"]);                     // attach a file
	}
	
	// Setup of the email
	$mail->Subject   = $result->fields["message_subject"];    // subject
	$mail->AltBody   = $text;                         // text-body
	
	// checks if a start index has been specified 
	$start_id = isset($result->fields["start_id"]) & !empty($result->fields["start_id"]) ? 0 : $result->fields["start_id"]; // start_id
	$end_id   = $start_id + $batch->getNrOfRowsPerBatch();                                                                     // end_id
	
	// specify some queries for updating the table later on	
	if(empty($c_node["cron"]["bulk_mail"])){		
		$update   = "UPDATE ".$db->prefix."_newsletter SET start_id='".($end_id+1)."' WHERE message_id = '".$_SESSION["s_newsletter_id"]."'";
		$delete   = "UPDATE ".$db->prefix."_newsletter SET message_status=1 WHERE message_id = '".$_SESSION["s_newsletter_id"]."'";
	}
	else{			
		$update   = "UPDATE ".$db->prefix."_newsletter SET start_id='".($end_id+1)."' WHERE message_id = '".$result->fields["message_id"]."'";
		$delete   = "UPDATE ".$db->prefix."_newsletter SET message_status=1 WHERE message_id = '".$result->fields["message_id"]."'";
	}
	
	// get the email addresses and firstnames
	if(isset($result->fields["item_type"]) && $result->fields["item_type"] == $c_node['newsletter']['type']['node']){
		if (isset($result->fields['to_type_id']) && $result->fields['to_type_id'] > 0) {
			//"to" level - 1=pending, 2=member -  
			$query = "
				SELECT u.user_firstname, u.user_surname, u.user_email 
				FROM  " . $db->prefix . "_user u 
				WHERE 
				u.language_id=". $result->fields['language_id'] . " and 
				u.status_id=". $result->fields['to_type_id']
			;
		} 
		else {
			//if not 1 or 2 we go to the invite table
			$query = "
				SELECT u.invited_email 
				FROM " . $db->prefix . "_user_invited u "
			;
		}
	}
	
	// get the total number of emails that should be sent
	$result = $db->Execute($query);
	$max = $result->RecordCount();
	$result->Close();
	
	// Getting "nr_addresses" persons to send to...
	$result = $db->SelectLimit($query, $batch->getNrOfRowsPerBatch(), $start_id);
	
	while(!$result->EOF){
	
		// HTML-version of the mail
		$html  = "<HTML><HEAD><TITLE></TITLE></HEAD>";
		$html .= "<BODY>";
		$html .= $body;
		$html .= "</BODY></HTML>";

		//format message
		if (isset($to_type_id) && $to_type_id > 0) {
			$html = str_replace("FIRSTNAME", $result->fields['user_firstname'], $html);
		}
		else {
			$html = $html;
		}
		
		$mail->Body = $html;

		// add new email-address to mailer-object
		$mail->AddAddress($result->fields["user_email"], $result->fields["user_firstname"]." ".$result->fields["user_surname"]);
	
		// Send email
		if(!$mail->Send())
			$error = "There has been a mail error sending to " . $result->fields["firstname"]." ".$result->fields["surname"] . "<br/>";
		
		// Clear all addresses for next loop
		$mail->ClearAddresses();
		
		$result->MoveNext();
	}
	
	$result->Close();
	
	// update the unsent newsletter table
	$query = ($end_id>=$max) ? $delete : $update; 
	$result = $db->Execute($query);
	$result->Close();
}

$mail->SmtpClose(); // Manually close the SMTP connection

// tidy up the database-----------------------------------------------------------------------
$db->Close();

// If not all emails sent, email again..
if(empty($c_node["cron"]["bulk_mail"])){
	// if more emails is to be sent
	if($end_id<$max){
		header("Location: send_newsletter.php");                   // send another batch of emails
		exit;
	}
	else{
		header("Location: ".$referrer);                            // send user back to newsletter page.
		exit;
	}
}

?>