<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
include "inc/header.inc.php";

//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');


if (isset($_REQUEST['blocked'])) {
	$output_blocked = getBlockUsers();

	$display = "view_blocked";

}
elseif (isset($_REQUEST['unblock'])) {
	require_once($c_node['class_dir'] . 'User/Socialnetwork.class.php');
	$sn = new Socialnetwork($me);
	$sn->db = $db;
    $user_blocked = $sn->unblockUser($_REQUEST['unblock_user_id'], 'unblock');

	$display = "view_blocked";
}
else if (isset($_REQUEST['edit_profile'])) {
	$output_template = getTemplates();
	$output_user['language_ids'] = $user->getLanguages();

	$action = "edit_profile";

}
else if (isset($_REQUEST['save_profile'])) {

	$data = $_POST['data'];

	//check the languages the user can read
	if (isset($_POST['language_ids'])) {
	    $data['language_ids'] = $_POST['language_ids'];
	}
	else {
		$error[]  = array('error', 28);
	}
	
	// Check the firstname
	if(empty($data['user_firstname'])) {
		$error[]  = array('error', 5);
	}

	// Check the email
	if(isset($data['user_email1']) && ($data['user_email1'] != $output_user['user_email'])) {

		if(empty($data['user_email1']) || empty($data['user_email2']))
			$error[]  = array('error', 2);

		if($data['user_email1'] != $data['user_email2'])
			$error[]  = array('error', 14);

		if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $data['user_email1']))
			$error[]  = array('error', 3);

		//check that the email is not already used
		$query = "
			SELECT user_id
			FROM " . $db->prefix . "_user
			WHERE user_email='" . $data['user_email1'] . "'"
		;

		$result = $db->Execute($query);

		if (isset($result)) {
			if (empty($result->fields)) {
				$updateEmail = 1;

				//append class vars
				$user->aroundme_dir = "";
				$user->language_dir = $c_node['template_default_name'];

				//get messaging texts
				require_once($languageTextPath . 'message.lang.php');

				//we now reset the password and send an email with the new login details
				$password = $user->createPassword();

				unset ($data['user_password1'], $data['user_password2']);

				//set up mail
				require_once($c_node['class_dir'] . '/Mail/class.phpmailer.php');
				$mail = new PHPMailer();
				$mail->Host = 		$c_node['mail']['host'];
				$mail->Mailer = 	$c_node['mail']['mailer'];
				$mail->From = 		$c_node['mail']['no_reply_address'];
				$mail->FromName = 	$c_node['mail']['from_name'];
				$mail->WordWrap = 	$c_node['mail']['wordwrap'];
				$mail->Subject = 	$lang['subject_new_details'];
				$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);

				$user->mail = $mail;

				$user->template_id = $data['template_id'];
				$user->emailVerification($password, $data['user_email1'], $data['user_firstname'], $data['language_id'], 'registration.txt.php', $c_node['www_path']);
				$success[]  = array('success', 5);

			}
			else {
				$error[]  = array('error', 4);
			}
		}
		else {
			$log[]  = array('error', 1, $db->ErrorMsg());
		}
		

	}


	// Check the password
	if(!empty($data['user_password1']) || !empty($data['user_password2'])) {
		
		if(empty($data['user_password1']) != empty($data['user_password2']))
			$error[]  = array('error', 15);

		if(strlen($data['user_password1']) < 5)
			$error[]  = array('error', 16);
	}

	// Check the hometown
	if(empty($data['user_hometown']))
		$error[]  = array('error', 10);

	// Check the nic
	if(empty($data['user_nic']))
		$error[]  = array('error', 7);


	if (empty($error)) {
	    //update db
		unset ($query, $result, $temp);


		$query = "
			UPDATE " . $db->prefix . "_user set
			user_firstname = '" . $data['user_firstname'] . "',
			user_surname = '" . $data['user_surname'] . "',
			language_id = '" . $data['language_id'] . "',
			template_id = '" . $data['template_id'] . "',
			user_nic = '" . $data['user_nic'] . "',
			user_hometown = '" . $data['user_hometown'] . "',
			user_summary = '" . $data['user_summary'] . "',
			user_birthtown = '" . $data['user_birthtown'] . "',
			user_gender = '" . $data['user_gender'] . "'"
		;

		//session_start();
		$_SESSION['s_language_id'] = $data['language_id'];

		if (!empty($data['user_ms_messenger'])) {
		   $query .= ", user_ms_messenger = '" . $data['user_ms_messenger'] . "'";
		}

		if (!empty($data['user_icq'])) {
		   $query .= ", user_icq = '" . $data['user_icq'] . "'";
		}

		if (!empty($data['user_yahoo_messenger'])) {
		   $query .= ", user_yahoo_messenger = '" . $data['user_yahoo_messenger'] . "'";
		}

		if (isset($updateEmail) && $updateEmail == 1) {
			//we lock the user until they answer the email notification to check they are who they say they are.
			$query .= ", user_email='" . $data['user_email1'] . "', user_locked=1";
		}

		if (isset($password)) { //if we have changed the email we create a new password

			$query .= ", user_password = '" . md5($password) . "'";
		}
		elseif (!empty($data['user_password1'])) {

			$query .= ", user_password = '" . md5($data['user_password1']) . "'";
			$success[]  = array('success', 6);
		}


		$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

		if ($dob != $output_user['user_dob']) {
		    $query .= ", user_dob = " . $db->DBDate($dob);
		}

		$query .= "
			WHERE
			user_id = " . $user_id
		;

		//echo $query . "<br><br>";

		$result = $db->Execute($query);
		if (!$result) {
				$error[]  = array('error', 1, $db->ErrorMsg());
		}
		else {
			$action = "view_profile";
			$success[]  = array('success', 2);
		}

		//update the user languages
		$user->deleteLanguages();
		$user->insertLanguages($data['language_ids']);
		$_SESSION['s_language_ids']   = $data['language_ids'];
		
		
		$output_user = $user->userDetails($user_id);
		$output_user['display_user_summary'] = nl2br($output_user['user_summary']);
		$output_user['language_ids'] = $user->getLanguages();

		$output_template = getTemplates();

	}
	else {
		$output_user['user_firstname'] = $data['user_firstname'];
		$output_user['user_email'] = $data['user_email1'];
		$output_user['user_hometown'] = $data['user_hometown'];
		$output_user['user_nic'] = $data['user_nic'];
		$output_user['user_email'] = $data['user_email1'];
		$output_user['language_ids'] = $data['language_ids'];
		
		$output_template = getTemplates();

		$action = "edit_profile";
	}
}
else {

	$output_user['template_title'] = getTemplate($output_user['template_id']);
	$output_user['display_user_summary'] = nl2br($output_user['user_summary']);

	$output_template = getTemplates();
	
	$output_user['language_ids'] = $user->getLanguages();

	$action = "view_profile";


}


//move to template
$body->set('user', $output_user);

if (isset($action)) {
   $body->set('action', $action);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (isset($output_blocked)) {
   $body->set('blocked', $output_blocked);
}

if (isset($output_blocked)) {
   $body->set('blocked', $output_blocked);
}

if (isset($output_template)) {
   $body->set('templates', $output_template);
}

$body->set('user_levels', $c_node['user_level_id']);

$body->set('datedropdown', $date->dateDropdown($output_user['user_dob']));

include "inc/footer.inc.php";



/*
* getTemplates
* Tom Calthrop 17th April 2004
*/
function getTemplates() {

	global $db, $log;

	$query = "
		SELECT t.*
		FROM " . $db->prefix . "_template t
		order by t.template_title"
	;

	$result = $db->Execute($query);

	if (!$result) {
	$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			array_push($temp, $result->fields);
			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
}//EO getTemplates();


/*
* getTemplate
* Tom Calthrop 17th April 2004
*/
function getTemplate($template_id) {

	global $db, $log;

	$query = "
		SELECT t.template_title
		FROM " . $db->prefix . "_template t
		WHERE
		t.template_id =" . $template_id
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		return $result->fields['template_title'];
	}
}//EO getTemplate();



//if the email was changed we log off the user
if (isset($updateEmail) && $updateEmail == true) {
	$user->logoffUser();
}



/*
* getBlockUsers
* get a list of users who are blocked by me
* tom calthrop 24th April 2004
*/
function getBlockUsers() {

	global $db, $me, $date;

	$query = "
		SELECT b.*, u.user_nic
		FROM " . $db->prefix . "_user_blocked b
		LEFT JOIN " . $db->prefix . "_user u ON b.user_id_blocked=u.user_id
		WHERE
		b.user_id_blocker=" . $me['user_id'] . "
		order by u.user_nic"
	;
	//echo $query;
    $result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['block_datetime'] = $date->formatDate($temp1['block_datetime']);
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getBlockUsers();


?>
