<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
$template_pagesection = "me";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'User/Bookmark.class.php');
require_once($c_node['class_dir'] . 'Poll.class.php');
require_once($c_node['class_dir'] . 'Group/Group.class.php');
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user_statistics.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');


//setup group
$group = new Group();
$group->db = $db;


//setup poll
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;


//setup forum
$forum = new Forum();
$forum->db = $db;
$forum->date = $date;
$forum->user_id = $me['user_id'];
$forum->image = $image;
$forum->poll = $poll;
$forum->node_id = $c_node['node_id'];


//setup bookmark items
$bookmark = new Bookmark($me['user_id'], $db, $date, $image, $poll);
$bookmark->forum = $forum;


//receive vars
if (isset($_POST['delete_bookmark'])) {

	$bookmark->bookmark_type = 1;

	if (isset($_POST['watch_group_delete_id']) && $_POST['watch_group_delete_id'] > 0) {
		$bookmark->deleteGroupItems($_POST['watch_group_delete_id']);
	}

	if (isset($_POST['watch_topic_delete_id']) && $_POST['watch_topic_delete_id'] > 0) {
		$bookmark->deleteTopicItems($_POST['watch_topic_delete_id']);
	}

	if (isset($_POST['watch_subject_delete_id']) && $_POST['watch_subject_delete_id'] > 0) {
		$bookmark->deleteSubjectItems($_POST['watch_subject_delete_id']);
	}

	if (isset($_POST['watch_library_delete_name']) && $_POST['watch_library_delete_name'] > 0) {
		$bookmark->deleteLibraryItems($_POST['watch_library_delete_name']);
	}

	if (isset($_POST['watch_event_delete_id']) && $_POST['watch_event_delete_id'] > 0) {
		$bookmark->deleteEventItems($_POST['watch_event_delete_id']);
	}

	if (isset($_POST['watch_blog_delete_id']) && $_POST['watch_blog_delete_id'] > 0) {
		$bookmark->deleteBlogItems($_POST['watch_blog_delete_id']);
	}

	$bookmark->bookmark_type = 2;

	if (isset($_POST['rec_group_delete_id']) && $_POST['rec_group_delete_id'] > 0) {
		$bookmark->deleteGroupItems($_POST['rec_group_delete_id']);
	}

	if (isset($_POST['rec_topic_delete_id']) && $_POST['rec_topic_delete_id'] > 0) {
		$bookmark->deleteTopicItems($_POST['rec_topic_delete_id']);
	}

	if (isset($_POST['rec_subject_delete_id']) && $_POST['rec_subject_delete_id'] > 0) {
		$bookmark->deleteSubjectItems($_POST['rec_subject_delete_id']);
	}

	if (isset($_POST['rec_library_delete_name']) && $_POST['rec_library_delete_name'] > 0) {
		$bookmark->deleteLibraryItems($_POST['rec_library_delete_name']);
	}

	if (isset($_POST['rec_event_delete_id']) && $_POST['rec_event_delete_id'] > 0) {
		$bookmark->deleteEventItems($_POST['rec_event_delete_id']);
	}

	if (isset($_POST['rec_blog_delete_id']) && $_POST['rec_blog_delete_id'] > 0) {
		$bookmark->deleteBlogItems($_POST['rec_blog_delete_id']);
	}

}


//get bookmark items
$bookmark->bookmark_type = 1;

$output_watched_groups = $bookmark->displayGroup($c_node['group_status']['active']);
$output_watched_topics = $bookmark->displayTopics();
$output_watched_subjects = $bookmark->displaySubjects();
$output_watched_library = $bookmark->displayLibrary();
$output_watched_blogs = $bookmark->displayBlog();
$output_watched_events = $bookmark->displayEvent();

$bookmark->bookmark_type = 2;

$output_recommended_groups = $bookmark->displayGroup($c_node['group_status']['active']);
$output_recommended_topics = $bookmark->displayTopics();
$output_recommended_subjects = $bookmark->displaySubjects();
$output_recommended_library = $bookmark->displayLibrary();
$output_recommended_blogs = $bookmark->displayBlog();
$output_recommended_events = $bookmark->displayEvent();



//move to template
if (isset($output_watched_topics)) {
	$body->set('watched_topics', $output_watched_topics);
}

if (isset($output_watched_subjects)) {
	$body->set('watched_subjects', $output_watched_subjects);
}

if (isset($output_watched_library)) {
	$body->set('watched_library', $output_watched_library);
}

if (isset($output_watched_groups)) {
	$body->set('watched_groups', $output_watched_groups);
}

if (isset($output_watched_blogs)) {
	$body->set('watched_blogs', $output_watched_blogs);
}

if (isset($output_watched_events)) {
	$body->set('watched_events', $output_watched_events);
}

if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_recommended_topics)) {
	$body->set('recommended_topics', $output_recommended_topics);
}

if (isset($output_recommended_subjects)) {
	$body->set('recommended_subjects', $output_recommended_subjects);
}

if (isset($output_recommended_library)) {
	$body->set('recommended_library', $output_recommended_library);
}

if (isset($output_recommended_groups)) {
	$body->set('recommended_groups', $output_recommended_groups);
}

if (isset($output_recommended_blogs)) {
	$body->set('recommended_blogs', $output_recommended_blogs);
}

if (isset($output_recommended_events)) {
	$body->set('recommended_events', $output_recommended_events);
}

$template_pageLink = $lang['href_watching'];
include "inc/footer.inc.php";

?>
