<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

if (isset($_REQUEST['topic_id'])) {
	$topic_id = $_REQUEST['topic_id'];
}
else {
	header("Location: g_forum.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
	exit;
}


//setup
$core = "group";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Poll.class.php');
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_user_online_status.lang.php');


//setup image
$image->thumb = "t1";

//setup poll
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;


//setup forum
$forum = new Forum();
$forum->db = $db;
$forum->date = $date;
$forum->user_id = $me['user_id'];
$forum->topic_id = $topic_id;
$forum->image = $image;
$forum->group_id = $group_id;
$forum->poll = $poll;
$forum->node_id = $c_node['node_id'];


//update bookmarks
if (isset($_REQUEST['watch'])) {
	$forum->updateTopicBookmark('watch');
}
elseif (isset($_REQUEST['recommend'])) {
	$forum->updateTopicBookmark('recommend');
}
elseif (isset($_REQUEST['unwatch'])) {
	$forum->updateTopicBookmark('unwatch');
}
elseif (isset($_REQUEST['unrecommend'])) {
	$forum->updateTopicBookmark('unrecommend');
}


//get topic
$output_topic = $forum->topicDetails();

//get subjects
$forum->image->thumb = "t2";
$output_subjects = $forum->subjectList();

//movement
$output_topic['movement'] = $forum->getTopicMovement('update');

$output_topic_author = $user->userDetails($output_topic['user_id']);
$output_topics = $forum->topicList($output_topic['section_id']);




//get users for each subject
if (isset($output_subjects)) {
	foreach($output_subjects as $key => $i):
		$output_subjects[$key]['user'] = $user->userDetails($i['user_id']);
	endforeach;
}


//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}
$body->set('topic', $output_topic);
$body->set('author', $output_topic_author);

if (isset($output_subjects)) {
    $body->set('subjects', $output_subjects);
}

if (isset($output_topics)) {
    $body->set('topics', $output_topics);
}


if (isset($output_topic['topic_title'])) {
	$template_pageLink = $lang['txt_topic'];
	$template_pageLinkNote = $output_topic['topic_title'];
}

include "inc/footer.inc.php";


/*
* addWatch
* bookmark this item or recommend this item
* Tom Calthrop 12th April 2004
*/
function addWatch ($topic_id, $type) {

	global $db, $me, $log;

	$query = "
		INSERT INTO " . $db->prefix . "_forum_bookmark (
		topic_id, user_id, node_id, bookmark_type
		) values (
		" . $topic_id . ",
		" . $me['user_id'] . ",
		" . $me['node_id'] . ",
		" . $type . "
		)"
	;
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		return 1;
	}
} //EO addWatch();


/*
* removeWatch
* remove bookmark for this item
* Tom Calthrop 12th April 2004
*/
function removeWatch ($topic_id, $type) {

	global $db, $me, $log;

	$query = "
		DELETE FROM " . $db->prefix . "_forum_bookmark
		WHERE
		topic_id=" . $topic_id . " and
		user_id=" . $me['user_id'] . " and
		node_id=" . $me['node_id'] . " and
		bookmark_type=" . $type
	;
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
} //EO removeWatch();


/*
* getWatch
* check to see if item is bookmarked or recommended
* Tom Calthrop 12th April 2004
*/
function getWatch ($topic_id, $type) {

	global $db, $me, $log;

	$query = "
		SELECT * FROM " . $db->prefix . "_forum_bookmark
		WHERE
		topic_id=" . $topic_id . " and
		user_id=" . $me['user_id'] . " and
		node_id=" . $me['node_id'] . " and
		bookmark_type=" . $type . "
		order by user_id limit 1"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		if ($result->fields['user_id']) {
		    return 1;
		}
	}
} //EO getWatch();
?>
