<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Shout {
	// Instance variables
	var $user_id;                        // User id
	var $db;                             // get db connect
	var $date;                           // get date for date formatting
	
	
	// Set the user id and $db connection in the constructor for simplicity
	function Shout($user_id, $db, $date) {
		$this->user_id = $user_id;
		$this->db = $db;
		$this->date = $date;
	}


	
	/*
	* GET SHOUT
	* tom calthrop
	* 8th Nov 2004
	*/
	function getShout () {
		//get newest shout
		$query = "
			SELECT s.shoutbox_body, s.shoutbox_create_datetime, s.user_id, u.user_nic
			FROM " . $this->db->prefix . "_shoutbox s
			LEFT JOIN " . $this->db->prefix . "_user u on s.user_id=u.user_id
			order by s.shoutbox_create_datetime desc"
		;

		$result = $this->db->SelectLimit($query, 1);
	
		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['shoutbox_create_datetime'] = $this->date->formatDate($temp['shoutbox_create_datetime']);
	
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
		
		$result->Close();
	}
	
	
	
	/*
	* GET SHOUTS
	* tom calthrop
	* 25th Jan 2004
	*/
	function getShouts() {
		$query = "
			SELECT s.shoutbox_body, s.shoutbox_create_datetime, s.user_id, u.user_nic
			FROM " . $this->db->prefix . "_shoutbox s
			LEFT JOIN " . $this->db->prefix . "_user u on s.user_id=u.user_id
			order by s.shoutbox_create_datetime desc"
		;
	
		$result = $this->db->SelectLimit($query, 25); //returns last 25 rows
		
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['shoutbox_create_datetime'] = $this->date->formatDate($temp1['shoutbox_create_datetime']);
	
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	}//EO getShouts();

	
	/*
	* INSERT SHOUT
	* tom calthrop
	* 8th Nov 2004
	*/
	function insertShout ($data) {
		$datetime = $this->db->DBTimeStamp(mktime());

		$shout_text = htmlspecialchars($data['shout_text']);

		$query = "
			INSERT INTO " . $this->db->prefix . "_shoutbox
			(shoutbox_body, user_id, shoutbox_create_datetime)
			values ('" . $shout_text . "', " . $this->user_id . ", " . $datetime . ")"
		;
	
		$result = $this->db->Execute($query);
		return header("Location: my_shoutbox.php?".SID);
		exit;
	}
}
?>
