<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "network";
$template_pagesection = "me";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_user_statistics.lang.php');


//setup statistics
$output_statistic = getStatistics();
$output_node_statistics = getNodeStatistics();


//move to template
if (isset($output_node_statistics)) {
	$body->set('node_statistics', $output_node_statistics);
}

if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_statistic)) {
	$body->set('user_statistic', $output_statistic);
}


$template_pageLink = $lang['txt_statistics'];
include "inc/footer.inc.php";


/*
* getStatistics
* Tom Calthrop 11th April 2004
*/
function getStatistics () {

	global $db, $me, $log;

	$query = "
		SELECT us.statistic_type_id, us.total
		FROM " . $db->prefix . "_user_statistic us
		where
		us.user_id=" . $me['user_id'] . "
		order by us.statistic_type_id"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getStatistics();


/*
* getNodeStatistics
* Tom Calthrop 11th April 2004
*/
function getNodeStatistics () {

	global $db, $me, $date, $log;

	$temp = array();

	//total users
	unset ($query,$result);
	$query = "
		SELECT count(user_id) as total_users
		FROM " . $db->prefix . "_user
		WHERE user_locked=2"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {
		$temp['total_users'] = $result->fields['total_users'];
		$result->Close();
	}

	//total groups
	unset ($query,$result);
	$query = "SELECT count(group_id) as total_groups FROM br_group";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {
		$temp['total_groups'] = $result->fields['total_groups'];
		$result->Close();
	}

	//total online now
	unset ($query,$result);
	$timestamp = $db->UserTimeStamp(mktime()-(60*15), "YmdHis"); //last 15 minutes

	$query = "
		SELECT count(user_id) as total_online_users
		FROM " . $db->prefix . "_user
		WHERE
		active_time > " . $timestamp
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {
		$temp['total_online_users'] = $result->fields['total_online_users'];
		$result->Close();
	}
	$datetime = date("Y-m-d H:i:s");
	$datetime = $date->formatDate($datetime);
	$temp['today'] = $datetime;

	return $temp;

}//EO getNodeStatistics();

?>
