<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'User/Guestbook.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');


//setup guestbook
$guestbook = new Guestbook($user_id, $db, $date, $image);


if(isset($_POST['insert_guestbook'])){
	$guestbook_text = stripslashes(htmlspecialchars($_POST['guestbook_text']));
    $guestbook->insertGuestbook($me['user_id'], $guestbook_text);
	header ("Location: sn_guestbook.php?user_id=" . $user_id . "&amp;" . SID);
	exit;
}

$output_guestbooks = $guestbook->getGuestbooks();


//update stats
if(isset($_POST['insert_guestbook']) && isset($output_guestbooks)){
	$user->setStatistic($c_node['user_statistic_type_id']['total_guestbooks'], count($output_guestbooks));
}


//move to template
if (isset($output_guestbooks)) {
    $body->set('guestbooks', $output_guestbooks);
}

if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

$template_pageLink =  $lang['txt_guestbook'];
$template_pageLinkNote = $lang['txt_profile'] . ": " . $output_user['user_nic'];

include "inc/footer.inc.php";
?>