<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "config/config_server.inc.php";
include "config/config_aroundme.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";




//SETUP DATABASE
require_once($c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
//$db->debug = true;
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//SETUP DATE
require_once($c_node['class_dir'] . 'Date.class.php');
$date = new Date();


//SETUP USER
require_once($c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->relation_type = $c_node['relation_type']['approved'];
$user->db = $db;
$user->date = $date;

$user->authUser();

$me = array(
		'user_id'=> 		$_SESSION['s_user_id'],
		'firstname'=> 		$_SESSION['s_firstname'],
		'surname'=> 		$_SESSION['s_surname'],
		'nic'=> 			$_SESSION['s_nic'],
		'level_id'=> 		$_SESSION['s_level_id'],
		'language_id'=> 	$_SESSION['s_language_id'],
		'language_ids'=> 	$_SESSION['s_language_ids'],
		'template_id'=> 	$_SESSION['s_user_template'],
		'homepage'=> 		$_SESSION['s_homepage'],
		'node_id'=> 		$_SESSION['s_node_id']
);



//SETUP MESSAGES
require_once($c_node['class_dir'] . 'User/IM.class.php');
$im = new IM($me['user_id'], $db, $c_node['message_box_max_size']);

// Setting the message status coding
$im->setStatus($c_node['message_status_unread'], $c_node['message_status_read']);
$im->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);
//get inbox unread message count
$me['mail'] = $im->messageCount();



//SETUP SHOUTBOX
require_once($c_node['class_dir'] . 'Shout.class.php');
$shout = new Shout($me['user_id'], $db, $date);
$shoutbox = $shout->getShout();


//setup image and move to user class
require_once($c_node['class_dir'] . 'Presentation/Image.class.php');
$image = new Image();
$image->db = $db;
$image->maxwidth = $c_node['image_max_width'];
$image->module = "user";
$user->image = $image;


//setup outter template
$template_path = $c_node['template_path'];

if (isset($me['template_id'])) {
    $template_name = $me['template_id'];
}
else {
	$template_name = $c_node['template_default_name'];
}

$template_path = $template_path . $template_name . "/";

require_once($c_node['class_dir'] . 'Presentation/Template.class.php');

$tpl = & new Template($template_path); // This is the outter template
$tpl->set('templatePath', $template_path);

$body = & new Template($template_path); // This is the inner template
$body->set('templatePath', $template_path);

$tpl->set('me', $me);
$body->set('me', $me);


//set some basic vars for general use
$page_name_full = basename($_SERVER['REQUEST_URI']);
$page_name = explode(".",$page_name_full);



//RETRIEVE ANY FORM VARS
if (isset($_POST['data'])) {
    $data = $_POST['data'];
}


//setup language paths for inclusion of language files
$languagePath = "language/" . $me['language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "arrays/";
$languageTextPath = $languagePath . "texts/";
require_once($languagePath . 'outer.lang.php');
require_once($languageArrayPath . 'arr_links.lang.php');
require_once($languageArrayPath . 'arr_error_success.lang.php');

$tpl->set('lang', $lang);

require_once($languagePath . $page_name[0] .'.lang.php');




/*
* SETUP Group or User
* * tom calthrop
* 9th Jan 2004
*/
if (isset($core) && $core == "my") {
	$user_id = $me['user_id'];

	$user->user_id = $user_id;
	$output_user = $user->userDetails();

}
elseif (isset($core) && $core == "user") { //sn

	if (isset($_REQUEST['user_id'])) {
		$user_id = $_REQUEST['user_id'];
	}
	else {
		$user_id = $me['user_id'];
	}

	//user details
	$user->user_id = $user_id;
	$output_user = $user->userDetails();

	//setup social network
	require_once($c_node['class_dir'] . 'User/Socialnetwork.class.php');
	$sn = new Socialnetwork($me['user_id'], $db, $me['node_id']);
	$sn->sn_arr = $_SESSION['s_social_network'];
	$sn->level_ids = $c_node['user_level_id'];
	$output_relationship = $sn->verifySocialNetwork($user_id);

	//envoke social policy
	if ((!isset($output_relationship) || $output_relationship['type'] < 1) && $page_name[0] != "sn_profile" && $page_name[0] != "sn_blog") {
	    header("Location: sn_profile.php?user_id=" . $user_id . "&amp;" . SID);
		exit;
	}


}
elseif (isset($core) && $core == "group") {
	//check received vars
	if ($page_name[0] != "g_groups" && $page_name[0] != "g_group_create") {
		if (isset($_REQUEST['group_id'])) {
			$group_id = $_REQUEST['group_id'];
		}
		else {
			header("Location: g_groups.php?" . SID);
			exit;
		}

		$image->group_id = $group_id;

		require_once($c_node['class_dir'] . 'Group/Group.class.php');
		$group = new Group($group_id);
		$group->db= $db;
		$group->date = $date;
		$group->node_id = $me['node_id'];
		$group->image = $image;
		$group->user_id = $me['user_id'];
		
		$output_group = $group->groupDetails();

		$output_group_member_level = $group->groupMemberLevel($me['user_id'], $output_group['group_type'], $c_node['group_type'], $c_node['user_level_id'], $me['level_id']);

	}

	//setup image
	$image->module = "group";

}
elseif (isset($core) && $core == "event") {

	if (!isset($_REQUEST['event_id']) && ($page_name[0] != "e_events" && $page_name[0] == "e_calendar" && $page_name[0] == "e_schedule")) {
		header("Location: e_events.php?" . SID);
		exit;
	}


	require_once($c_node['class_dir'] . 'Event/Event.class.php');
	$event = new Event();
	$event->date = $date;
	$event->db = $db;
	$event->image = $image;
	$event->event_activity_type = $c_node['activity_user_status'];
	$event->node_id = $me['node_id'];
	$event->user_id = $me['user_id'];

	if (isset($_REQUEST['event_id'])) {
		$event_id = $_REQUEST['event_id'];
		$event->event_id = $event_id;
	}

	if (isset($_REQUEST['group_id']) && $_REQUEST['group_id'] > 0) {
		$group_id = $_REQUEST['group_id'];
		$event->group_id = $group_id;
		$event->image->module = "group";

		require_once($c_node['class_dir'] . 'Group/Group.class.php');
		$group = new Group($group_id);
		$group->db= $db;
		$group->date = $date;
		$group->node_id = $me['node_id'];
		$group->image = $image;
		$group->image->group_id = $group_id;

		$output_group = $group->groupDetails();

		$output_group_member_level = $group->groupMemberLevel($me['user_id'], $output_group['group_type'], $c_node['group_type'], $c_node['user_level_id'], $me['level_id']);

		if (($output_group_member_level['user_level_id'] < $c_node['user_level_id']['moderator']) && (isset($_REQUEST['add_event']) || isset($_REQUEST['edit_event']))) {
			header("Location: g_groups.php?".SID);
			exit;
		}
	}
	else {
		$group_id = 0;
	}


	if (isset($_REQUEST['activity_id'])) {
		$activity_id = $_REQUEST['activity_id'];
		$event->activity_id = $activity_id;
	}
}


//set homepage
if (isset($_REQUEST['homepage'])) {
	$sethomepage = setHomepage($page_name[0] . ".php");
}

if ($me['homepage'] == $page_name[0] . ".php") {
    $body->set('homepage', 1);
}


//check to see if I can see the node admin screen
if ($me['level_id'] >= $c_node['user_level_id']['node_administrator']) {
    $tpl->set('show_node_admin_link', 1);
}
?>
