<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Image {

var $image, $imagepath, $maxwidth, $thumb;
//var $subdir = "../asset/"; 	// INSERT Subdirectory like "images/" here.

var $thumbnailsizes = array('t1' => 160,'t2' => 80); 	//Sizes here.


	function checkImage() {
		$ext = strrchr($this->image['name'], ".");
		$extlow = strtolower($ext);

		if ($extlow != ".jpg") {
			$state[] = array('error', 17);
		}

		if (isset($state)) {
		   return $state;


		}




	}


	function makeThumbnails($dest) {
		$size=getimagesize($dest);
		$height=$size[1];
		$width=$size[0];
		foreach ($this->thumbnailsizes as $key => $newwidth){
			$newheight=intval($height*$newwidth/$width);
			$original=ImageCreateFromJPEG($dest);

			//color error fix - tom - 16th April 2004
			if (function_exists('ImageCreateTrueColor')) {
				// use imagecreatetruecolor
				$thumbnail=ImageCreateTrueColor($newwidth,$newheight);
			} else {
				// use imagecreate
				$thumbnail=ImageCreate($newwidth,$newheight);
			}

			ImageCopyResized($thumbnail,$original,0,0,0,0,$newwidth,$newheight,ImageSX($original),ImageSY($original));
  			//ImageCopyResized($thumbnail,$original,0,0,0,0,$newwidth,$newheight,$width,$height);
			$newdest=ereg_replace(strrchr($dest,"."),"",$dest);
			$newdest .= "_".$key.".jpg";
  			ImageJPEG($thumbnail,$newdest, 75);
		}
	}


	function uploadImage($image) {		//returns TRUE if the image was uploaded, else dies.

		$this->image = $image;

		$dest = $this->imagepath . "/";
		//$dest .= $this->image['name'];

		//remove spaces from filename
		$this->image['name'] = str_replace(" ", "", $this->image['name']);

		$ext = strrchr($this->image['name'], ".");
		$extlow = strtolower($ext);
		$filename = substr($this->image['name'], 0, -4);

		//$dest .= $this->image['name'];
		$dest .= $filename . $extlow;

		$state = $this->checkImage();

		if(is_file($this->image['tmp_name']) && empty($state)) {

			move_uploaded_file($this->image['tmp_name'], $dest);

			$size=getimagesize($dest);
			$width=$size[0];
			$height=$size[1];

			$image_id = imagecreatefromjpeg($dest);

			if ($width > $this->maxwidth) {
				//resize the image
				$new_width = $this->maxwidth;
				$new_height = $height * ($this->maxwidth / $width);

				// Create and copy
				$newimage_id = ImageCreateTrueColor($new_width, $new_height);
				$newimage = ImageCopyResampled($newimage_id, $image_id, 0, 0, 0, 0, $new_width, $new_height, $width, $height);

            }
			else {
				$newimage_id = ImageCreateTrueColor($width, $height);
				$newimage = ImageCopyResampled($newimage_id, $image_id, 0, 0, 0, 0, $width, $height, $width, $height);

			}

			ImageJPEG($newimage_id, $dest);

			$this->makeThumbnails($dest);



		}
		else {
		    return $state;
		}



   	 }



	/*
	* DISPLAY IMAGE
	* tom calthrop
	* 21st Feb 2004
	*/
	function getImage ($image_id, $thumb = null, $module = null, $id = null) {

		if (!isset($thumb) && isset($this->thumb)) {
		    $thumb = $this->thumb;
		}

		if (!isset($module)) {
		    $module = $this->module;
		}

		if (!isset($id) && $module == "group" && isset($this->group_id)) {
		    $id = $this->group_id;
		}
		elseif (!isset($id) && $module == "user" && isset($this->user_id)) {
		    $id = $this->user_id;
		}

		$query = "
			SELECT i.*
			FROM " . $this->db->prefix . "_" . $module . "_image i
			where
			i.image_id=" . $image_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = $result->fields;
			$result->Close();

			if (isset($temp['image_id'])) {

				if (!isset($id) && isset($temp['group_id'])) {
				    $id = $temp['group_id'];
				}
				elseif (!isset($id) && isset($temp['user_id'])) {
				    $id = $temp['user_id'];
				}

				if ($thumb) {
				  	$temp['image'] = $module . "/" . $id . "/" . $temp['image_filename'] . "_" . $thumb . "." . $temp['image_mime'];
				}
				else {
					$temp['image'] = $module . "/" . $id . "/" . $temp['image_filename'] . "." . $temp['image_mime'];

				}
				return $temp;
			}
		}
	}


	/*
	* DISPLAY IMAGES
	* tom calthrop
	* 21st Feb 2004
	*/
	function getImages ($module, $id, $thumb = null) {
		$query = "
			SELECT i.*
			FROM " . $this->db->prefix . "_" . $module . "_image i
			where "
		;

		if ($module == "user") {
		    $query .="i.user_id=" . $id;
		}
		else if ($module == "group") {
		    $query .="i.group_id=" . $id;
		}

		$query .=" order by i.image_title";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['image'] = $module . "/" . $id . "/" . $temp1['image_filename'] . "_" .$thumb. "." . $temp1['image_mime'];
			$temp1['image_size'] = round($temp1['image_size']/1000);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		$output = $temp;

		}

		return $output;
	}

	/*
	* GET THE TOTAL STORAGE USED BY THE USERS IMAGES
	* tom calthrop
	* 21st Feb 2004
	*/
	function getTotalBytesUsed ($module, $id) {
		$query = "
			SELECT i.image_size
			FROM " . $this->db->prefix . "_" . $module . "_image i
			where "
		;

		if ($module == "user") {
		    $query .="i.user_id=" . $id;
		}
		else if ($module == "group") {
		    $query .="i.group_id=" . $id;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
		$temp = array();

		$temp['total_size'] = 0;

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp['total_size'] = $temp1['image_size'] + $temp['total_size'];
			$result->MoveNext();
		}
		$temp['total_size'] = round($temp['total_size']/1000);

		$result->Close();
		$output = $temp;
		}

		return $output;
	}



	/*
	* INSERT IMAGE
	* tom calthrop
	* 21st Feb 2004
	*/
	function insertImage ($module, $id, $image_title) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);
		$filename = ereg_replace(strrchr($this->image['name'],"."),"",$this->image['name']);
		$filemime = "jpg";
		$size = $this->image['size'];

		if ($module == "user") {

			$query = "
				INSERT INTO " . $this->db->prefix . "_user_image (
				user_id,
				image_filename,
				image_mime,
				image_create_datetime,
				image_title,
				image_size)
				values
				(
				'" . $id . "',
				'" . $filename . "',
				'" . $filemime . "',
				" . $datetime . ",
				'" . $image_title . "',
				'" . $size . "'
				)"
			;
			//echo $query;

		}
		else {
			$query = "
				INSERT INTO " . $this->db->prefix . "_group_image (
				group_id,
				image_filename,
				image_mime,
				image_create_datetime,
				image_title,
				image_size)
				values
				(
				'" . $id . "',
				'" . $filename . "',
				'" . $filemime . "',
				" . $datetime . ",
				'" . $image_title . "',
				'" . $size . "'
				)"
			;
			//echo $query;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 2);
		}

		return $state;


	} //EO insertImage();


	/*
	* DELETE IMAGE
	* tom calthrop
	* 21st Feb 2004
	*/
	function deleteImageFile ($filename, $filemime) {

		//remove image from Hard Disk
		$removepath = $this->imagepath . "/";

		$remove1 = $removepath . $filename . "." . $filemime;
		$remove2 = $removepath . $filename . "_t1." . $filemime;
		$remove3 = $removepath . $filename . "_t2." . $filemime;

		if (is_file($remove1)) {
		   	unlink($remove1);
		}

		if (is_file($remove2)) {
		   	unlink($remove2);
		}

		if (is_file($remove3)) {
		   	unlink($remove3);
		}


	} //EO deleteImage();


	/*
	* DELETE IMAGE FROM DB
	* tom calthrop
	* 21st Feb 2004
	*/
	function deleteImage ($module, $id) {

		if ($module == "user") {
			$query = "DELETE FROM " . $this->db->prefix . "_user_image WHERE image_id=" . $id;
		}
		else {
			$query = "DELETE FROM " . $this->db->prefix . "_group_image WHERE image_id=" . $id;
		}

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 4);
		}

		return $state;


	} //EO deleteImage();


	/*
	* UDPATE IMAGE
	* tom calthrop
	* 21st Feb 2004
	*/
	function updateImage ($module, $image_id, $image_title, $user_id) {


		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (isset($this->image['size']) && $this->image['size'] > 0) {

			$filename = ereg_replace(strrchr($this->image['name'],"."),"",$this->image['name']);
			$filemime = "jpg";
			$size = $this->image['size'];

			$query = "
				UPDATE " . $this->db->prefix . "_" . $module . "_image SET
				user_id_edit=" . $user_id . ",
				image_edit_datetime=" . $datetime . ",
				image_title='" . $image_title . "',
				image_filename='" . $filename . "',
				image_mime='" . $filemime . "',
				image_size='" . $size . "'
				WHERE image_id=" . $image_id;
			;

		}
		else {
			$query = "
				UPDATE " . $this->db->prefix . "_" . $module . "_image SET
				user_id_edit=" . $user_id . ",
				image_edit_datetime=" . $datetime . ",
				image_title='" . $image_title . "'
				WHERE image_id=" . $image_id;
			;

		}

		//echo $query;


		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 3);
		}

		return $state;


	} //EO updateImage();


	/*
	* updateDefaultImage
	* Tom Calthrop 7th April 2004
	*/
	function updateDefaultImage ($module, $id, $default_image_id, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if ($module == "group") {
			$query = "
				UPDATE " . $this->db->prefix . "_group SET
				group_edit_datetime=" . $datetime . ",
				user_id_edit=" . $user_id . ",
				group_image_id =" . $default_image_id . "
				WHERE
				group_id=" . $id
			;
		}
		else {
			$query = "
				UPDATE " . $this->db->prefix . "_user SET
				user_edit_datetime=" . $datetime . ",
				user_image_id =" . $default_image_id . "
				WHERE
				user_id=" . $id
			;
		}



		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 3);
		}

		return $state;
	}



}
?>
