<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");


require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['library'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$library->file = $file;

// get the latest revisions
$library->limit = 12;
$output_revisions = $library->selRevisions(null, 1);

if (!empty($output_revisions)) {
	$body->set('revisions', $output_revisions);
}

// get latest sets
$library->status_id = $library_config['status']['live'];
$library->limit = 4;
$library->order_by = "set_create_datetime desc";
$output_sets = $library->selSets();

if (!empty($output_sets)) {
	$body->set('sets', $output_sets);
}

unset ($library->order_by, $library->limit);


// participation in wiki sets
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['library'];
	$participation->status_id = $core_config['participation']['status']['active'];
	
	$output_participation = $participation->selParticipants(null, null, $_SESSION['user_id']);
	
	if (!empty($output_participation)) {
		// we get item_id's and we get the sets from that
		foreach ($output_participation as $key => $i):
			$library->set_ids[] = $i['item_id'];
		endforeach;
		
		
		if (!empty($library->set_ids)) {
			$output_my_sets = $library->selSets();
		}
		
		$body->set('my_sets', $output_my_sets);
	}

	// FAVOURITES -----------------------------------------
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['library']);
	$bookmark->user_id = $_SESSION['user_id'];
	
	// get my bookmarked favourites
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$library->page_ids[] = $i['inner_item_id'];
		endforeach;
		
		unset ($library->file);
		
		if (!empty($library->page_ids)) {
			$output_my_bookmarks = $library->selPages(null, 1);
		}
		
		$body->set('my_bookmarks', $output_my_bookmarks);
	}
	
	// REVISIONS FROM RESPECTED NETWORK
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

	// get latest revisions from our respected network
	$query = "
		SELECT distinct i.identity_id, i.identity_nic, i.file_id, lr.revision_id, lr.revision_create_datetime,
		lp.page_title, lp.set_id
		FROM " . $db->prefix . "_library_revision lr
		INNER JOIN " . $db->prefix . "_library_page lp
		ON lr.page_id=lp.page_id
		INNER JOIN " . $db->prefix . "_user_identity i
		ON lr.user_id=i.user_id
		INNER JOIN " . $db->prefix . "_participation p
		ON (p.module_id=" . $core_config['module_id']['library'] . " AND 
		p.item_id=lr.page_id AND p.identity_id=i.identity_id)
		INNER JOIN " . $db->prefix . "_relation r
		ON r.identity_id_relation=p.identity_id
		WHERE r.user_id=" . $_SESSION['user_id'] . "
		ORDER BY lr.revision_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 6);

	if (isset($result->fields)) {
		$output_respected_published_revisions = array();

		while (!$result->EOF) {
			$temp = $result->fields;

			if (isset($temp['file_id'])) {
				if (isset($file->thumb)) {
					$temp['image'] = $file->selFile($temp['file_id'], $file->thumb);
				}
				else {
					$temp['image'] = $file->selFile($temp['file_id'], "t2");
				}
			
			}
			else {
				$temp['image']['file_title'] = "";
				$temp['image']['file_md5_name_view'] = '0-' . $file->no_image;
			}

			array_push($output_respected_published_revisions, $temp);

			$result->MoveNext();
		}
		
		if (!empty($output_respected_published_revisions)) {
			$body->set('respected_published_revisions', $output_respected_published_revisions);
		}
	}

	// COMMENTS FROM RESPECTED NETWORK
	$query = "
		SELECT distinct i.identity_id, i.identity_nic, i.file_id, c.comment_id, c.comment_create_datetime, 
		c.comment_body, c.item_id, c.module_id, c.inner_item_id, c.inner_item_revision
		FROM " . $db->prefix . "_comment c
		INNER JOIN " . $db->prefix . "_user_identity i
		ON c.user_id=i.user_id
		INNER JOIN " . $db->prefix . "_participation p
		ON (p.module_id=" . $core_config['module_id']['library'] . " AND 
		p.item_id=c.item_id AND p.identity_id=i.identity_id)
		INNER JOIN " . $db->prefix . "_relation r
		ON r.identity_id_relation=p.identity_id
		WHERE r.user_id=" . $_SESSION['user_id'] . " AND c.module_id=" . $core_config['module_id']['library'] . "
		ORDER BY c.comment_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 6);

	if (isset($result->fields)) {
		$output_respected_published_comments = array();

		while (!$result->EOF) {
			$temp = $result->fields;

			if (isset($temp['file_id'])) {
				if (isset($file->thumb)) {
					$temp['image'] = $file->selFile($temp['file_id'], $file->thumb);
				}
				else {
					$temp['image'] = $file->selFile($temp['file_id'], "t2");
				}
			
			}
			else {
				$temp['image']['file_title'] = "";
				$temp['image']['file_md5_name_view'] = '0-' . $file->no_image;
				$temp['image']['type'] = "image/png";
				$temp['image']['directory'] = "";
			}

			array_push($output_respected_published_comments, $temp);

			$result->MoveNext();
		}
		
		if (!empty($output_respected_published_comments)) {
			$body->set('respected_published_comments', $output_respected_published_comments);
		}
	}
}

?>
