<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// Permission check
if ($_SESSION['user_mod_permission'] & $core_config['resource']['module']['lbr']['maint']) {

	$menu_section = "set";
	
	include_once ("config/lbr.config.php");
	include_once ("inc/lbr_initiate.inc.php");
	
	// update set
	if (isset($_POST['update_set'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_library_set  
			WHERE 
			set_id=" . $_POST['maint_set_id']
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['status_id'] = $_POST['status_id'];

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}

		// update allocation
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $_POST['maint_set_id'] . " AND
			module_id=" . $core_config['module_id']['library']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['file_allocation'] = $_POST['file_allocation']*1000;

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}

	
	// list sets
	$output_sets = $library->selSets();

	if (!empty($output_sets)) {
		$body->set('sets', $output_sets);
	}

	if (isset($_POST['maint_set_id'])) {
		// GET PROJECT
		$output_set = $library->selSet($_POST['maint_set_id']);
		$participation->item_id = $output_set['set_id'];
	}
	elseif (isset($_REQUEST['set_id'])) {
		// GET PROJECT
		$output_set = $library->selSet($_REQUEST['set_id']);
	}

	if (!empty($output_set)) {
		// get arbiter
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		
		if (isset($core_config['module'])) {
			$file->core_config_module = $core_config['module'];
		}
		
		$file->module_id = 0; // core
		
		$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		$user->file = $file;

		$output_owner = $participation->selParticipation($output_set['user_id']);
		$output_identity = $user->selUserIdentity(null, $output_owner['identity_id']);
		$body->set('identity', $output_identity);
		
		// ALLOCATIONS
		$output_set['file_allocation'] = "0";
		
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $output_set['set_id'] . " AND 
			module_id=" . $core_config['module_id']['library']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_set['file_allocation'] = $result->fields['file_allocation']/1000;
		}

		$body->set('set', $output_set);
	}
	else { // get statistics
		$output_statistics = array();

		$query = "
			SELECT set_type, count(set_type) as set_count 
			FROM " . $db->prefix . "_library_set
			GROUP BY set_type"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['set_type'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
		$query = "
			SELECT status_id, count(status_id) as status_count
			FROM " . $db->prefix . "_library_set
			GROUP BY status_id"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['status'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
				
		if (!empty($output_statistics)) {
			$body->set('statistics', $output_statistics);
		}
	}

	
}
else {
	header("Location: index.php?amn=" . $_SESSION['user_homepage'] . "&" . strip_tags(SID));
	exit;
}
?>
