<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");


// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['library'], null,  $core_config);


// SETUP TAGS ------------------------------------------------------------
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db);


// FORMAT LIBRARY ENTRY -------------------------------------------------------
if (!empty($output_page) && !empty($output_revision)) {
	// set an array of pages that exist in the library
	$pages = $library->selPages($output_page['set_id']);
	
	// apply interlinks
	$output_revision['revision_body'] = $library->applyInterLinks($output_revision['revision_body'], $pages, $output_set['set_id']);
	// apply toc
	$output_revision['revision_body'] = $library->applyToc($output_revision['revision_body']);

	$output_revision['revision_body'] =  str_replace ( "\\", "&#92;", $output_revision['revision_body']);
	
	$body->set('revision', $output_revision);
	$body->set('set', $output_set);
	
	// get author
	$author_participation = $participation->selParticipation($output_revision['user_id']);
	$output_identity = $user->selUserIdentity(null, $author_participation['identity_id']);
	
	
	// get identities
	if (!empty($output_participants)) {
		// get their ids
		if (!empty($output_participants)) {
			foreach ($output_participants as $key => $i):
				$user->identity_ids[] = $i['identity_id'];
			endforeach;
			
			$user->identity_ids = array_unique($user->identity_ids);
			
			if (!empty($user->identity_ids)) {
				$output_identities = $user->selUserIdentities();
				
				// we place the identities against the participants
				if (!empty($output_identities)) {
					foreach ($output_participants as $keyp => $p):
						foreach ($output_identities as $keyi => $i):
							if ($p['identity_id'] == $i['identity_id']) {
								$output_participants[$keyp]['identity'] = $i;
								break;
							}
						endforeach;
					endforeach;
				}
				
				$body->set('participants', $output_participants);
			}
		}
	}
	
	// get latest revisions
	$library->limit = 6;
	$output_revisions = $library->selRevisions($output_page['page_id']);
	$body->set('revisions', $output_revisions);
	
	
	if (!empty($_SESSION['md5'])) {
		// FAVOURITES -----------------------------------------
		require_once('components/core/class/Bookmark.class.php');
		$bookmark = new Bookmark($db, $core_config['module_id']['library']);
		$bookmark->item_id = $output_set['set_id'];
		$bookmark->user_id = $_SESSION['user_id'];	
		$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
		$bookmark->inner_item_id = $output_page['page_id'];
		// bookmarks
		
		// 0=unset, 1=set
		if (isset($_POST['mark_0_x'])) {
			$bookmark->deleteBookmark();
		}
		elseif (isset($_POST['mark_1_x'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_POST['mark_2_x'])) {
			$bookmark->insertBookmark(1);
		}
		elseif (isset($_POST['recommend_0_x'])) {
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->deleteBookmark();
		}
		elseif (isset($_POST['recommend_1_x'])) {
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->insertBookmark();
		}
		
		
		// GET BOOKMARK --------------------------------------------------
		if (isset($bookmark)) {
			$bookmark->item_id = $output_set['set_id'];
			$bookmark->inner_item_id = $output_page['page_id'];
			$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_page['bookmark']['watch'] = 1;
			}
			
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_page['bookmark']['recommend'] = 1;
			}
		}
		
		
		// get my bookmarked favourites for this set
		$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
		unset($bookmark->inner_item_id);
		$output_bookmarks = $bookmark->selBookmarks(1);
		
		if (!empty($output_bookmarks)) {
			// we get item_id's and we get the sets from that
			foreach ($output_bookmarks as $key => $i):
				$library->page_ids[] = $i['inner_item_id'];
			endforeach;
			
			unset ($library->file);
			
			if (!empty($library->page_ids)) {
				$output_my_bookmarks = $library->selPages(null, 1);
			}
			
			$body->set('my_bookmarks', $output_my_bookmarks);
		}
		
		
		// GET RATINGS -----------------------------------------------------
		require_once('components/core/class/Rate.class.php');
		$rate = new Rate($db, $core_config['module_id']['library']);
		$rate->item_id = $output_set['set_id'];
		$rate->user_id = $_SESSION['user_id'];	
		$rate->rate_type = $core_config['rate']['type']['relevent'];
		$rate->inner_item_id = $output_page['page_id'];
		
		// 0=unset, 1=set
		if (isset($_POST['relevent_0_x'])) {
			$rate->deleteRating();
			$rate->insertRating(0);
		}
		elseif (isset($_POST['relevent_1_x'])) {
			$rate->deleteRating();
			$rate->insertRating(1);
		}
		elseif (isset($_POST['accurate_0_x'])) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$rate->deleteRating();
			$rate->insertRating(0);
		}
		elseif (isset($_POST['accurate_1_x'])) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$rate->deleteRating();
			$rate->insertRating(1);
			
		}
		
		// select my ratings on this page
		$rate->rate_type = $core_config['rate']['type']['relevent'];
		$output_rating_relevent = $rate->selRating();
		
		if (isset($output_rating_relevent)) {
			if (isset($output_rating_relevent[0]['rate_value'])) {
				$output_page['rate']['relevent']['value'] = $output_rating_relevent[0]['rate_value'];
			}
		}
		
		$rate->rate_type = $core_config['rate']['type']['accurate'];
		$output_rating_accurate = $rate->selRating();
		
		if (isset($output_rating_accurate)) {
			if (isset($output_rating_accurate[0]['rate_value'])) {
				$output_page['rate']['accurate']['value'] = $output_rating_accurate[0]['rate_value'];
			}
		}
		
		unset($rate->user_id);
		
		// statistics
		if (isset($output_rating_relevent)) {
			$rate->rate_type = $core_config['rate']['type']['relevent'];
			$output_page['rate']['relevent']['total'] = $rate->countRating();
			$output_page['rate']['relevent']['positive'] = $rate->countRating(1);
			
			if (!empty($output_page['rate']['relevent']['total'])) {
				$percentage = round((100 / $output_page['rate']['relevent']['total']) * $output_page['rate']['relevent']['positive']);
				$total_votes = $output_page['rate']['relevent']['total'];
			}
			else {
				$percentage = "0";
				$total_votes = "0";
			}
			
			$lang['txt_relevent_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_relevent_summary']);
			$lang['txt_relevent_summary'] = str_replace("SYS_KEYWORD_TOTAL", $total_votes, $lang['txt_relevent_summary']);
		}
		
		if (isset($output_rating_accurate)) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$output_page['rate']['accurate']['total'] = $rate->countRating();
			$output_page['rate']['accurate']['positive'] = $rate->countRating(1);
			
			if (!empty($output_page['rate']['accurate']['total'])) {
				$percentage = round((100 / $output_page['rate']['accurate']['total']) * $output_page['rate']['accurate']['positive']);
				$total_votes = $output_page['rate']['accurate']['total'];
			}
			else {
				$percentage = "0";
				$total_votes = "0";
			}
			
			$lang['txt_accurate_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_accurate_summary']);
			$lang['txt_accurate_summary'] = str_replace("SYS_KEYWORD_TOTAL", $total_votes, $lang['txt_accurate_summary']);
		}
		
		
		
		// select tags
		require_once('components/core/class/Tag.class.php');
		$tag = new Tag($db, $core_config['module_id']['library'], $library_config['tag']['lbr']['page']);
		$tag->item_id = $output_set['set_id'];
		$tag->inner_item_id = $output_page['page_id'];
		$tag->user_id = $_SESSION['user_id'];	
		
		if (isset($_POST['insert_tag']) && !empty($_POST['tag_body'])) {
			if (empty($_POST['tag_id'])) { // we insert
				$tag->insertTag($_POST['tag_body']);
			}
			elseif (!empty($_POST['tag_id'])) { // we delete
				$tag->deleteTag($_POST['tag_id']);
			}
			else { // we update tag
				$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
			}
		}
		elseif (isset($_POST['delete_tag']) && !empty($_POST['tag_id'])) {
			$tag->deleteTag($_POST['tag_id']);
		}
		elseif (isset($_REQUEST['edit_tag'])) {
			$output_tag = $tag->selTag($_REQUEST['edit_tag']);
		
			if (!empty($output_tag)) {
			$body->set('tag', $output_tag);
			}
		}
		
		$output_tags = $tag->selTags();
		
		if (!empty($output_tags)) {
			$body->set('tags', $output_tags);
		}
	}
	
		
	$body->set('page', $output_page);
	
	
	
	// SET AND GET COMMENTS ----------------------------------------------
	if (isset($_POST['insert_comment'])) {
		$comment->user_id = $_SESSION['user_id'];
		$comment->item_id = $output_set['set_id'];
		$comment->inner_item_id = $output_page['page_id'];
		$comment->item_user_id = $output_revision['user_id'];
		$comment->inner_item_revision = $output_revision['revision_id'];

		require_once('components/core/class/Kses/kses.php');
		
		$rec['comment_body'] = kses_parse($_POST['comment_body'], 'min');
		
		if (empty($GLOBALS['am_error_log'])) {
			$comment->insertComment($_POST);
			
			// insert statistics ------------------------------
			require_once('components/core/class/Statistic.class.php');
			$statistic = new Statistic($db, $library_config['statistic']);
			$statistic->module_id = $core_config['module_id']['library'];
			$statistic->user_id = $_SESSION['user_id'];
			
			// insert library statistic - library-set comments
			$statistic->statistic_type_id = $library_config['statistic']['total_set_comment'];
			$statistic->item_id = $output_set['set_id'];
			$statistic->setStatistic($comment->countComments());
			
			unset($statistic->module_id, $comment->item_id, $comment->inner_item_id);
			
			// insert user statistic - total comments
			$statistic->item_id = $_SESSION['user_id'];
			$statistic->statistic_type_id = $core_config['statistic']['user']['total_comments'];
			$statistic->setStatistic($comment->countComments());
		}
		else {
			$output_comment = $_POST;
			$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);

			$body->set('comment', $output_comment);
		}
	}
	elseif (isset($_POST['preview_comment'])) {
		$output_comment = $_POST;

		require_once('components/core/class/Kses/kses.php');
		
		$output_comment['display_comment_body'] = kses_parse($output_comment['comment_body'], 'min');
		
		$output_comment['display_comment_body'] = renderHTML($output_comment['display_comment_body']);
		$output_comment['display_comment_body'] = stripslashes($output_comment['display_comment_body']);

		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
		$output_comment['comment_body'] = htmlspecialchars($output_comment['comment_body']);

		$body->set('comment', $output_comment);
		$body->set('display', 'preview_comment');
	}
	elseif (isset($_POST['edit_comment_again'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
		$body->set('comment', $output_comment);
	}
	
	unset ($comment->user_id);
	
	$comment->item_id = $output_set['set_id'];
	$comment->inner_item_revision = $output_revision['revision_id'];
	
	$output_comments = $comment->selComments($output_page['page_id']);
	
	$body->set('comments', $output_comments);
	
	
	if (!empty($_SESSION['md5'])) {
		require_once ('components/core/class/Network.class.php');
		$network = new Network($db, $core_config, null, $output_identity['identity_id']);
		
		// GET AND SET RELATIONSHIP -----------------------------------------------
		if (isset($output_participation) && $output_revision['user_id'] != $_SESSION['user_id']) {
			
			$network->setIdentities($output_participation['identity_id'], $output_identity['identity_id']);
			$output_matrix = $network->selMatrix();
			$body->set('matrix', $output_matrix);
			
			// GET THEIR TESTIMONIAL COUNT ---------------------------
			require_once ("components/core/class/Testimonial.class.php");
			$testimonial = new Testimonial($db);
			$testimonial->identity_id = $output_identity['identity_id'];
			$testimonial->testifier_identity_id = $output_participation['identity_id'];

			// count testimonials
			$output_identity['testimonial_count'] = $testimonial->countTestimonials();
		}
		elseif ($output_revision['user_id'] != $_SESSION['user_id']) { // we select "the best card"
			
// 			$network = new Network($db, $core_config, null, $output_identity['identity_id']);
			$network->user_id = $_SESSION['user_id'];
			$network->identity_type = $core_config['user']['identity']['type']['registered'];
			$output_matrix = $network->selMatrix();
			$body->set('matrix', $output_matrix);
		}
		
		if (isset($_REQUEST['respect']) && $_REQUEST['respect'] == 1 ) {
			
			$data['module_id'] = $core_config['module_id']['library'];
			$data['item_id'] = $output_set['set_id'];
			$data['identity_id'] = $output_matrix[0]['identity']['identity_id'];
			$data['identity_id_relation'] = $output_identity['identity_id'];
			$data['relation_create_datetime'] = time();
			$data['user_id'] = $_SESSION['user_id'];
			
			$network->insertRespect($data);
			$network->setIdentities($data['identity_id'], $data['identity_id_relation']);
			$network->im = $im;
			
			$output_matrix[0]['relation']['respected'] = 1; // is now respected
			$body->set('matrix', $output_matrix);
			
			include_once($language_path_core . 'inc/network_common.inc.php');
			if ($network->isMutual()) {
	
				$message_body = readTxtFile($language_path_core . "texts/im_mutual_respect.txt.php");
				$message_body = str_replace("SYS_KEYWORD_NAME", $output_identity['identity_nic'], $message_body);

				$suffix = $core_config['module'][$core_config['module_id']['library']]['prefix'];
				if (is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
					include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
				}

				$function_name = "selItemModule_" . $suffix;
		
				if (function_exists($function_name)) {
					$respected_item = $function_name($data['item_id']);
					$message_body = str_replace("SYS_KEYWORD_ITEM", $respected_item['item_title'], $message_body);
					$message_body = str_replace("SYS_KEYWORD_URL", $respected_item['item_url'], $message_body);
				}
	
				$network->message_body = $message_body;
				$network->message_subject = $lang['txt_subject_mutual'];
				$network->insertRespectMessage($data['identity_id_relation'], $data['identity_id']);
			}
			elseif ($core_config['node']['network_mode'] == 1) {
	
				$core_identity_url = "index.php?amn=core_profile&identity_id=" . $data['identity_id'];
				$core_identity_name = $output_identity['identity_nic'];
				$message_body = readTxtFile($language_path_core . "texts/im_respect.txt.php");
				$message_body = str_replace("SYS_KEYWORD_NAME", $core_identity_name, $message_body);
				$message_body = str_replace("SYS_KEYWORD_URL", $core_identity_url, $message_body);
		
				$network->message_body = $message_body;
				$network->message_subject = $lang['txt_subject_respect'];
				$network->insertRespectMessage($data['identity_id_relation']);
			}
		}
	}
	
	$body->set('identity', $output_identity);
}
else {
	header("Location: index.php?amn=lbr_overview&" . strip_tags(SID));
	exit;
}

?>