<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");


// select set tags
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, $core_config['module_id']['library'], $library_config['tag']['lbr']['library']);
$tag->level_id = $core_config['tag']['level']['item'];

$output_set_tags = $tag->selTags(1);				

if (!empty($output_set_tags)) {
	$body->set('set_tags', $output_set_tags);
}

// page tags
unset ($tag->level_id);

$output_tags = $tag->selTags(1);				

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

// get highest rated wiki sets
require_once('components/core/class/Rate.class.php');
$rate = new Rate($db, $core_config['module_id']['library']);

$output_rating = $rate->selRating(1);				

if (!empty($output_rating)) {
	// get the pages for each rating
	foreach ($output_rating as $key => $i):
		$library->page_ids[] = $i['inner_item_id'];
	endforeach;
	
	$library->page_ids = array_unique($library->page_ids);
				
	if (!empty($library->page_ids)) {
		$output_rated_pages = $library->selPages(null, 1);
	}
	
	// apply the totals to the pages
	if (!empty($output_rated_pages)) {
		foreach ($output_rated_pages as $keyp => $p):
			foreach ($output_rating as $keyi => $i):
				if ($p['page_id'] == $i['inner_item_id']) {
					$output_rated_pages[$keyp]['total'] = $i['total'];
					break;
				}
			endforeach;
		endforeach;
	}

	$body->set('rated_pages', $output_rated_pages);
}

// get the highest recommendations
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['library']);
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];

$output_recommendations = $bookmark->selBookmarks(null, 1);	

unset ($library->page_ids);

if (!empty($output_recommendations)) {
	// get the pages for each recommendation
	foreach ($output_recommendations as $key => $i):
		$library->page_ids[] = $i['inner_item_id'];
	endforeach;
	
	$library->page_ids = array_unique($library->page_ids);
				
	if (!empty($library->page_ids)) {
		$output_recommended_pages = $library->selPages(null, 1);
	}
	
	// apply the totals to the pages
	if (!empty($output_recommended_pages)) {
		foreach ($output_recommended_pages as $keyp => $p):
			foreach ($output_recommendations as $keyi => $i):
				if ($p['page_id'] == $i['inner_item_id']) {
					$output_recommended_pages[$keyp]['total'] = $i['total'];
					break;
				}
			endforeach;
		endforeach;
	}

	$body->set('recommended_pages', $output_recommended_pages);
}
	
	
?>
