<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section= "library";

$output_set['item_id'] = $output_set['set_id'];
$body->set('item', $output_set);


// GET FAVOURITES --------------------------------------------------------
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['library']);

// get my bookmarked favourites
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
$output_bookmarks = $bookmark->selBookmarks(1);

if (!empty($output_bookmarks)) {
	// we get item_id's and we get the sets from that
	foreach ($output_bookmarks as $key => $i):
		$library->page_ids[] = $i['inner_item_id'];
	endforeach;
	
	unset ($library->file);
	
	if (!empty($library->page_ids)) {
		$output_bookmarks = $library->selPages(null, 1);
	}
	
	$body->set('recommendations', $output_bookmarks);
}



// GET USER STATISTICS ---------------------------------------------------
require_once('components/core/class/Statistic.class.php');
$statistic = new Statistic($db, $library_config['statistic']);
$statistic->module_id = $core_config['module_id']['library'];
$statistic->item_id = $output_set['set_id'];

$output_statistics['library'] = $statistic->selStatistics();

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}


// WIKI SETS ------------------------------------------------
// get the wiki sets that I am contributing to
unset($participation->item_id);
$output_set_participation = $participation->selParticipants(null, null, $output_identity_relation['user_id']);

if (!empty($output_set_participation)) {
	// get participants for each item
	foreach($output_set_participation as $key => $i):
		$library->set_ids[] = $i['item_id'];
	endforeach;
	
	$library->file = $file;
	$library->file->module_id = $core_config['module_id']['library'];
	$library->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	$library->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	

	$output_user_sets = $library->selSets();
	
	if (!empty($output_user_sets)) {
		$body->set('user_sets', $output_user_sets);
	}		
}



// GET LATEST COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['library']);

$comment->module_id = $core_config['module_id']['library'];
$comment->item_id = $output_set['set_id'];
$comment->user_id = $output_identity_relation['user_id'];
$comment->limit = 4;
$comment->order_by = "c.comment_create_datetime desc";

$output_comments = $comment->selComments();

if (!empty($output_comments)) {
	$body->set('latest_comments', $output_comments);
}


// GET LATEST REVISIONS -------------------------------------------
$library->limit = 16;
$library->user_id = $output_identity_relation['user_id'];

$output_revisions = $library->selRevisions(null, 1);

if (!empty($output_revisions)) {
	$body->set('revisions', $output_revisions);
}



if (!empty($_SESSION['md5'])) {
	// GET AND SET RELATIONSHIP -----------------------------------------------
	if (isset($output_participation)) {
		require_once ("components/core/class/Tie.class.php");
		$tie = new Tie($db, $core_config);
		$tie->module_id = $core_config['module_id']['library'];
		$tie->item_id = $output_set['set_id'];
		
		$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
		
		if (empty($output_relationship) && !empty($_REQUEST['respect'])) {
			
			$tie->user_id = $_SESSION['user_id'];
			
			$data['identity_id'] = $output_participation['identity_id'];
			$data['identity_id_relation'] = $output_identity_relation['identity_id'];
			
			if (!empty($_REQUEST['portable'])) {
				$data['relation_portable'] = 1;
			}
			
			$tie->insertRelation($data);
			
			$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity_relation['identity_id']);
		}		
		
		
		if (!empty($output_relationship)) {
			if ($tie->isMutual($output_identity['identity_id'], $output_participation['identity_id'])) {
				$output_relationship['mutual'] = 1;
			}
			
			$body->set('relationship', $output_relationship);
		}
	}
}


?>
